/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.impl;

import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.webcontext.session.SessionModel;
import org.tinygroup.weblayer.webcontext.session.SessionModelEncoder;

public class SessionModelEncoderImpl
implements SessionModelEncoder {
    private static final Logger log = LoggerFactory.getLogger(SessionModelEncoderImpl.class);
    private static final String pattern = "'{'id:\"{0}\",ct:{1,number,#},ac:{2,number,#},mx:{3,number,#}'}'";

    public Object encode(SessionModel model) {
        Object[] args = new Object[]{ObjectUtil.defaultIfNull((Object)model.getSessionID(), (Object)""), model.getCreationTime(), model.getLastAccessedTime(), model.getMaxInactiveInterval()};
        String data = new MessageFormat(pattern).format(args);
        if (log.isDebugEnabled()) {
            log.debug("Stored session model data: {}", (Object)data);
        }
        return data;
    }

    public SessionModel decode(Object data, SessionModel.Factory factory) {
        SessionModel model;
        block3: {
            model = null;
            if (data instanceof String) {
                log.trace("Trying to parse session model data: {}", data);
                try {
                    Object[] values = new MessageFormat(pattern).parse((String)data);
                    String sessionID = StringUtil.trimToNull((String)((String)values[0]));
                    long creationTime = (Long)values[1];
                    long lastAccessedTime = (Long)values[2];
                    int maxInactiveInterval = ((Long)values[3]).intValue();
                    model = factory.newInstance(sessionID, creationTime, lastAccessedTime, maxInactiveInterval);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Could not parse session model data: " + data, (Throwable)e);
                }
            }
        }
        return model;
    }
}

