/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.impl;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.weblayer.webcontext.session.SessionConfig;
import org.tinygroup.weblayer.webcontext.session.SessionModel;
import org.tinygroup.weblayer.webcontext.session.impl.SessionImpl;

public class SessionModelImpl
implements SessionModel {
    private transient SessionConfig sessionConfig;
    private String sessionID;
    private long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;

    public SessionModelImpl(SessionImpl session) {
        this.setSession(session);
        this.reset();
    }

    public SessionModelImpl(String sessionID, long creationTime, long lastAccessedTime, int maxInactiveInterval) {
        this.sessionID = sessionID;
        this.creationTime = creationTime;
        this.lastAccessedTime = lastAccessedTime;
        this.maxInactiveInterval = maxInactiveInterval;
    }

    private SessionConfig getSessionConfig() {
        return (SessionConfig)Assert.assertNotNull((Object)this.sessionConfig, (String)"sessionConfig", (Object[])new Object[0]);
    }

    public void reset() {
        this.getSessionConfig();
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.maxInactiveInterval = this.sessionConfig.getMaxInactiveInterval();
    }

    public void setSession(SessionImpl session) {
        this.sessionConfig = session.getSessionWebContext().getSessionConfig();
        this.sessionID = session.getId();
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public boolean isExpired() {
        long expires;
        int maxInactiveInterval = this.getMaxInactiveInterval();
        long forceExpirationPeriod = this.getSessionConfig().getForceExpirationPeriod();
        long current = System.currentTimeMillis();
        if (forceExpirationPeriod > 0L && (expires = this.getCreationTime() + forceExpirationPeriod * 1000L) < current) {
            return true;
        }
        return maxInactiveInterval > 0 && (expires = this.getLastAccessedTime() + (long)(maxInactiveInterval * 1000)) < current;
    }

    public void touch() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        DateFormat fmt = DateFormat.getDateTimeInstance(1, 1, Locale.US);
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        mb.append("sessionID", (Object)this.sessionID);
        mb.append("creationTime", (Object)(this.creationTime <= 0L ? "n/a" : fmt.format(new Date(this.creationTime))));
        mb.append("lastAccessedTime", (Object)(this.lastAccessedTime <= 0L ? "n/a" : fmt.format(new Date(this.lastAccessedTime))));
        mb.append("maxInactiveInterval", (Object)this.maxInactiveInterval);
        return new ToStringBuilder().append((Object)"SessionModel").append((Object)mb).toString();
    }
}

