/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.commons.tools.StringUtil;

public class ServletUtil {
    public static boolean isPrefixServletMapping(HttpServletRequest request) {
        int index;
        String pathInfo = StringUtil.trimToNull((String)request.getPathInfo());
        if (pathInfo != null) {
            return true;
        }
        String servletPath = StringUtil.trimToEmpty((String)request.getServletPath());
        return servletPath.indexOf(".", (index = servletPath.lastIndexOf("/")) + 1) >= 0;
    }

    public static String getResourcePath(HttpServletRequest request) {
        String pathInfo = FileUtil.normalizeAbsolutePath((String)request.getPathInfo(), (boolean)false);
        String servletPath = FileUtil.normalizeAbsolutePath((String)request.getServletPath(), (pathInfo.length() != 0 ? 1 : 0) != 0);
        return servletPath + pathInfo;
    }

    public static String getBaseURL(HttpServletRequest request) {
        String fullPath;
        String fullURL = request.getRequestURL().toString();
        try {
            fullPath = new URL(fullURL).getPath();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + fullURL, e);
        }
        StringBuilder buf = new StringBuilder(fullURL);
        buf.setLength(fullURL.length() - fullPath.length());
        buf.append(FileUtil.normalizeAbsolutePath((String)request.getContextPath(), (boolean)true));
        return buf.toString();
    }

    public static String getServletResourcePath(HttpServletRequest request) {
        String resourcePath = ServletUtil.isPrefixServletMapping(request) ? request.getPathInfo() : request.getServletPath();
        resourcePath = FileUtil.normalizeAbsolutePath((String)resourcePath, (boolean)false);
        return resourcePath;
    }

    public static String getServletBaseURL(HttpServletRequest request) {
        String fullPath;
        String fullURL = request.getRequestURL().toString();
        try {
            fullPath = new URL(fullURL).getPath();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + fullURL, e);
        }
        StringBuilder buf = new StringBuilder(fullURL);
        buf.setLength(fullURL.length() - fullPath.length());
        buf.append(FileUtil.normalizeAbsolutePath((String)request.getContextPath(), (boolean)true));
        if (ServletUtil.isPrefixServletMapping(request)) {
            buf.append(FileUtil.normalizeAbsolutePath((String)request.getServletPath(), (boolean)true));
        }
        return buf.toString();
    }

    public static String normalizeURI(String uri) {
        return URI.create(StringUtil.trimToEmpty((String)uri)).normalize().toString();
    }

    public static boolean startsWithPath(String path, String fullpath) {
        if (fullpath != null && path != null) {
            if (path.endsWith("/")) {
                return fullpath.startsWith(path);
            }
            if (path.length() == fullpath.length()) {
                return fullpath.equals(path);
            }
            if (path.length() < fullpath.length()) {
                return fullpath.startsWith(path + "/");
            }
        }
        return false;
    }
}

