/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.TinyProcessor;
import org.tinygroup.weblayer.TinyProcessorConfig;
import org.tinygroup.weblayer.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTinyProcessor
implements TinyProcessor {
    protected String processorName;
    protected TinyProcessorConfig tinyProcessorConfig;
    protected static Logger logger = LoggerFactory.getLogger(AbstractTinyProcessor.class);

    @Override
    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }

    @Override
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    public void init(TinyProcessorConfig tinyProcessorConfig) throws ServletException {
        this.tinyProcessorConfig = tinyProcessorConfig;
        this.customInit();
    }

    protected abstract void customInit() throws ServletException;

    @Override
    public void destroy() {
    }

    @Override
    public boolean isMatch(String urlString) {
        return this.tinyProcessorConfig.isMatch(urlString);
    }

    @Override
    public void process(String urlString, WebContext context) throws ServletException, IOException {
        this.reallyProcess(urlString, context);
    }

    protected String get(String param) {
        return this.tinyProcessorConfig.getInitParameter(param);
    }

    protected Map<String, String> getInitParamMap() {
        return this.tinyProcessorConfig.getParameterMap();
    }

    public int getOrder() {
        return 0;
    }

    public abstract void reallyProcess(String var1, WebContext var2) throws ServletException, IOException;
}

