/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.FilterWrapper;
import org.tinygroup.weblayer.TinyFilterHandler;
import org.tinygroup.weblayer.TinyFilterManager;
import org.tinygroup.weblayer.TinyProcessorManager;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManager;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManagerHolder;
import org.tinygroup.weblayer.impl.WebContextImpl;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.xmlparser.node.XmlNode;

public class TinyHttpFilter
implements Filter {
    public static final String DEFAULT_POST_DATA_KEY = "$_post_data_key";
    public static final String DEFAULT_POST_NODE_NAME = "$_post_node_name";
    public static final String DEFAULT_PAGE_KEY = "$_default_page";
    private static final String EXCLUDE_PATH = "excludePath";
    private static final Logger logger = LoggerFactory.getLogger(TinyHttpFilter.class);
    private static final String POST_DATA_PROCESS = "post-data-process";
    private static final String DATA_MAPPING = "data-mapping";
    private static final String HOST_PATTERN = "host-pattern";
    private static final String POST_DATA_KEY = "post-data-key";
    private static String[] defaultFiles = new String[]{"index.page", "index.htm", "index.html", "index.jsp"};
    private TinyProcessorManager tinyProcessorManager;
    private TinyFilterManager tinyFilterManager;
    private List<Pattern> excludePatterns = new ArrayList<Pattern>();
    private Map<String, String> mapping = new HashMap<String, String>();
    private String postDataKey;
    private FilterWrapper wrapper;
    private FullContextFileRepository fullContextFileRepository;

    public void destroy() {
        this.destroyTinyProcessors();
        this.destroyTinyFilters();
    }

    private void destroyTinyFilters() {
        this.tinyFilterManager.destoryTinyResources();
    }

    private void destroyTinyProcessors() {
        this.tinyProcessorManager.destoryTinyResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.requestInitListener(servletRequest);
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String servletPath = this.getServletPath(request);
            if (this.isExcluded(servletPath)) {
                logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84:<{}>,\u88ab\u62d2\u7edd", new Object[]{servletPath});
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            WebContextImpl context = new WebContextImpl();
            context.put("springUtil", BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()));
            this.postDataProcess(request, context);
            context.put("context", context);
            context.putSubContext("applicationproperties", (Context)new ContextImpl(ConfigurationUtil.getConfigurationManager().getConfiguration()));
            this.putRequestInfo(request, context);
            context.init(request, response, ServletContextHolder.getServletContext());
            if (servletPath.endsWith("/")) {
                for (String defaultFile : defaultFiles) {
                    String tmpPath = servletPath + defaultFile;
                    FileObject fileObject = this.fullContextFileRepository.getFileObject(tmpPath);
                    if (fileObject == null || !fileObject.isExist()) continue;
                    servletPath = tmpPath;
                    request.setAttribute(DEFAULT_PAGE_KEY, (Object)servletPath);
                    break;
                }
            }
            TinyFilterHandler handler = new TinyFilterHandler(servletPath, filterChain, context, this.tinyFilterManager, this.tinyProcessorManager);
            if (this.wrapper != null) {
                this.wrapper.filterWrapper(context, handler);
            } else {
                handler.tinyFilterProcessor(request, response);
            }
        }
        finally {
            this.requestDestroyListener(servletRequest);
        }
    }

    private void requestInitListener(ServletRequest servletRequest) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<ServletRequestListener> listeners = configManager.getRequestListeners();
        ServletRequestEvent event = new ServletRequestEvent(ServletContextHolder.getServletContext(), servletRequest);
        for (ServletRequestListener listener : listeners) {
            logger.logMessage(LogLevel.DEBUG, "ServletRequestListener:[{0}] will be requestInitialized", new Object[]{listener});
            listener.requestInitialized(event);
            logger.logMessage(LogLevel.DEBUG, "ServletRequestListener:[{0}] requestInitialized", new Object[]{listener});
        }
    }

    private void requestDestroyListener(ServletRequest servletRequest) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<ServletRequestListener> listeners = configManager.getRequestListeners();
        ServletRequestEvent event = new ServletRequestEvent(ServletContextHolder.getServletContext(), servletRequest);
        for (ServletRequestListener listener : listeners) {
            logger.logMessage(LogLevel.DEBUG, "ServletRequestListener:[{0}] will be requestDestroyed", new Object[]{listener});
            listener.requestDestroyed(event);
            logger.logMessage(LogLevel.DEBUG, "ServletRequestListener:[{0}] requestDestroyed", new Object[]{listener});
        }
    }

    private String getServletPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (StringUtil.isBlank((String)servletPath)) {
            servletPath = request.getPathInfo();
        }
        if (StringUtil.isBlank((String)servletPath)) {
            servletPath = "/";
        }
        return servletPath;
    }

    private void postDataProcess(HttpServletRequest request, WebContext context) throws IOException {
        if (this.isPostMethod(request)) {
            String remoteHost = request.getRemoteHost();
            String remoteAddr = request.getRemoteAddr();
            for (String pattern : this.mapping.values()) {
                if (!Pattern.matches(pattern, remoteHost) && !Pattern.matches(pattern, remoteAddr)) continue;
                context.put(this.postDataKey, StreamUtil.readBytes((InputStream)request.getInputStream(), (boolean)true).toByteArray());
                break;
            }
        }
    }

    private boolean isPostMethod(HttpServletRequest request) {
        return request.getMethod().equalsIgnoreCase("post");
    }

    private void initPostDataProcess() {
        ConfigurationManager appConfigManager = ConfigurationUtil.getConfigurationManager();
        XmlNode parserNode = (XmlNode)appConfigManager.getApplicationConfiguration().getSubNode(POST_DATA_PROCESS);
        if (parserNode != null) {
            this.postDataKey = StringUtil.defaultIfBlank((String)parserNode.getAttribute(POST_DATA_KEY), (String)DEFAULT_POST_DATA_KEY);
            List dataMapNode = parserNode.getSubNodes(DATA_MAPPING);
            if (!CollectionUtil.isEmpty((Collection)dataMapNode)) {
                for (int i = 0; i < dataMapNode.size(); ++i) {
                    XmlNode xmlNode = (XmlNode)dataMapNode.get(i);
                    String hostsPattern = xmlNode.getAttribute(HOST_PATTERN);
                    if (StringUtil.isBlank((String)hostsPattern)) continue;
                    String nodeName = xmlNode.getAttribute("name");
                    if (StringUtil.isBlank((String)nodeName)) {
                        nodeName = DEFAULT_POST_NODE_NAME + i;
                    }
                    this.mapping.put(nodeName, hostsPattern);
                }
            }
        }
    }

    private void putRequestInfo(HttpServletRequest request, WebContext context) {
        String path = request.getContextPath();
        if (path == null) {
            path = "";
        }
        context.put("TINY_CONTEXT_PATH", path);
        context.put("TINY_REQUEST_URI", request.getRequestURI());
        String servletPath = request.getServletPath();
        if (servletPath == null || servletPath.length() == 0) {
            servletPath = request.getPathInfo();
        }
        context.put("TINY_SERVLET_PATH", servletPath);
    }

    private boolean isExcluded(String servletPath) {
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(servletPath).matches()) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.logMessage(LogLevel.INFO, "filter\u521d\u59cb\u5316\u5f00\u59cb...");
        this.fullContextFileRepository = (FullContextFileRepository)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("fullContextFileRepository");
        this.initExcludePattern(filterConfig);
        this.initTinyFilters();
        this.initTinyFilterWrapper();
        this.initTinyProcessors();
        this.initPostDataProcess();
        logger.logMessage(LogLevel.INFO, "filter\u521d\u59cb\u5316\u7ed3\u675f...");
    }

    private void initTinyFilterWrapper() {
        this.wrapper = this.tinyFilterManager.getFilterWrapper();
    }

    private void initExcludePattern(FilterConfig filterConfig) {
        this.excludePatterns.clear();
        String excludePath = filterConfig.getInitParameter(EXCLUDE_PATH);
        if (excludePath != null) {
            String[] excludeArray;
            for (String path : excludeArray = excludePath.split(",")) {
                this.excludePatterns.add(Pattern.compile(path));
            }
        }
    }

    private void initTinyFilters() throws ServletException {
        this.tinyFilterManager = (TinyFilterManager)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("tinyFilterManager");
        this.tinyFilterManager.initTinyResources();
    }

    private void initTinyProcessors() throws ServletException {
        this.tinyProcessorManager = (TinyProcessorManager)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("tinyProcessorManager");
        this.tinyProcessorManager.initTinyResources();
    }
}

