/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.applicationprocessor;

import org.tinygroup.application.AbstractApplicationProcessor;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.webcontext.session.Session;
import org.tinygroup.weblayer.webcontext.session.SessionConfiguration;
import org.tinygroup.weblayer.webcontext.session.SessionManager;
import org.tinygroup.weblayer.webcontext.session.model.SessionManagerFactory;
import org.tinygroup.xmlparser.node.XmlNode;

public class SessionMonitorApplicationProcessor
extends AbstractApplicationProcessor {
    private Thread thread = null;
    private boolean threadDone;
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionBackgroundProcessor.class);

    public void start() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "SessionBackgroundProcessor";
        this.thread = new Thread((Runnable)new SessionBackgroundProcessor(), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public String getApplicationNodePath() {
        return null;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
    }

    public XmlNode getComponentConfig() {
        return null;
    }

    public XmlNode getApplicationConfig() {
        return null;
    }

    public int getOrder() {
        return 0;
    }

    class SessionBackgroundProcessor
    implements Runnable {
        private static final String SESSION_CONFIGURATION_BEAN_NAME = "sessionConfiguration";

        public void run() {
            SessionConfiguration sessionConfiguration = (SessionConfiguration)((Object)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(SESSION_CONFIGURATION_BEAN_NAME));
            SessionConfiguration.ConfigImpl sessionConfig = sessionConfiguration.getSessionConfig();
            SessionManager sessionManager = SessionManagerFactory.getSessionManager(sessionConfig.getSessionManagerBeanId(), this.getClass().getClassLoader());
            int backgroundProcessorDelay = sessionConfig.getBackgroundProcessorDelay();
            while (!SessionMonitorApplicationProcessor.this.threadDone) {
                try {
                    Thread.sleep((long)backgroundProcessorDelay * 1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    if (SessionMonitorApplicationProcessor.this.threadDone) continue;
                    this.processExpires(sessionManager);
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u76d1\u63a7session\u5931\u6548\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
        }

        public void processExpires(SessionManager sessionManager) {
            Session[] sessions = sessionManager.queryAllSessions();
            long timeNow = System.currentTimeMillis();
            int expireHere = 0;
            LOGGER.logMessage(LogLevel.DEBUG, "Start expire sessions at {0} sessioncount:{1}", new Object[]{timeNow, sessions.length});
            for (int i = 0; i < sessions.length; ++i) {
                if (sessions[i] == null || !sessions[i].isExpired()) continue;
                sessions[i].invalidate();
                ++expireHere;
            }
            long timeEnd = System.currentTimeMillis();
            LOGGER.logMessage(LogLevel.DEBUG, "End expire sessions  processingTime:{0} expired sessions: {1}", new Object[]{timeEnd - timeNow, expireHere});
        }
    }
}

