/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.configmanager;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.Configuration;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.config.TinyProcessorConfigInfo;
import org.tinygroup.weblayer.config.TinyProcessorConfigInfos;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xstream.XStreamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyProcessorConfigManager
implements Configuration {
    public static final String TINY_PROCESSOR_CONFIGMANAGER = "tinyProcessorConfigManager";
    private static final String TINY_PROCESSOR_NODE_PATH = "/application/tiny-processors";
    private Map<String, TinyProcessorConfigInfo> processorMap = new HashMap<String, TinyProcessorConfigInfo>();
    private List<TinyProcessorConfigInfo> processorConfigs = new ArrayList<TinyProcessorConfigInfo>();
    private XmlNode applicationConfig;
    private XmlNode componentConfig;
    private static Logger logger = LoggerFactory.getLogger(TinyProcessorConfigManager.class);

    public void addConfig(TinyProcessorConfigInfos configInfos) {
        List<TinyProcessorConfigInfo> configList = configInfos.getConfigInfos();
        for (TinyProcessorConfigInfo configInfo : configList) {
            String name = configInfo.getConfigName();
            if (StringUtil.isBlank((String)name)) {
                logger.logMessage(LogLevel.WARN, "please set tiny processor name in name or id property");
            }
            if (this.processorMap.containsKey(name)) {
                logger.logMessage(LogLevel.WARN, "already exist processor name:[{0}],please reset the processor name", new Object[]{name});
                continue;
            }
            this.processorMap.put(name, configInfo);
            this.processorConfigs.add(configInfo);
        }
    }

    public void removeConfig(TinyProcessorConfigInfos configInfos) {
        List<TinyProcessorConfigInfo> configList = configInfos.getConfigInfos();
        for (TinyProcessorConfigInfo configInfo : configList) {
            String name = configInfo.getConfigName();
            this.processorMap.remove(name);
            this.processorConfigs.remove(configInfo);
        }
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public String getApplicationNodePath() {
        return TINY_PROCESSOR_NODE_PATH;
    }

    public String getComponentConfigPath() {
        return "/tinyprocessor.config.xml";
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
    }

    private void combineConfig(List<XmlNode> combineList) {
        XStream stream = XStreamFactory.getXStream((String)"weblayer");
        for (XmlNode xmlNode : combineList) {
            TinyProcessorConfigInfos filterConfigInfos = (TinyProcessorConfigInfos)stream.fromXML(xmlNode.toString());
            List<TinyProcessorConfigInfo> configInfos = filterConfigInfos.getConfigInfos();
            for (TinyProcessorConfigInfo configInfo : configInfos) {
                String name = configInfo.getConfigName();
                if (this.processorMap.containsKey(name)) {
                    TinyProcessorConfigInfo originalInfo = this.processorMap.get(name);
                    logger.logMessage(LogLevel.DEBUG, "processor name:[{0}] combine [{1}] with [{2}]", new Object[]{name, originalInfo, configInfo});
                    originalInfo.combine(configInfo);
                    continue;
                }
                this.processorMap.put(name, configInfo);
                this.processorConfigs.add(configInfo);
            }
        }
    }

    public void combineConfig() {
        ArrayList<XmlNode> combineList = new ArrayList<XmlNode>();
        if (this.componentConfig != null) {
            combineList.add(this.componentConfig);
        }
        if (this.applicationConfig != null) {
            combineList.add(this.applicationConfig);
        }
        this.combineConfig(combineList);
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public TinyProcessorConfigInfo getProcessorConfig(String processorName) {
        return this.processorMap.get(processorName);
    }

    public List<TinyProcessorConfigInfo> getProcessorConfigs() {
        return this.processorConfigs;
    }
}

