/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.config.TinyListenerConfigInfos;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManager;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManagerHolder;
import org.tinygroup.xstream.XStreamFactory;

public class TinyListenerFileProcessor
extends AbstractFileProcessor {
    private static final String LISTENER_EXT_FILENAMES = ".tinylisteners.xml";

    public void process() {
        TinyListenerConfigInfos oldConfigs;
        XStream stream = XStreamFactory.getXStream((String)"weblayer");
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664tiny-listener\u63cf\u8ff0\u6587\u4ef6\uff1a<{}>", new Object[]{fileObject.getAbsolutePath()});
            oldConfigs = (TinyListenerConfigInfos)this.caches.get(fileObject.getAbsolutePath());
            if (oldConfigs != null) {
                configManager.removeConfig(oldConfigs);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664tiny-listener\u63cf\u8ff0\u6587\u4ef6\uff1a<{}>\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            oldConfigs = (TinyListenerConfigInfos)this.caches.get(fileObject.getAbsolutePath());
            if (oldConfigs != null) {
                configManager.removeConfig(oldConfigs);
            }
            LOGGER.logMessage(LogLevel.INFO, "\u627e\u5230tiny-listener\u63cf\u8ff0\u6587\u4ef6\uff1a<{}>", new Object[]{fileObject.getAbsolutePath()});
            TinyListenerConfigInfos configInfos = (TinyListenerConfigInfos)stream.fromXML(fileObject.getInputStream());
            configManager.addConfig(configInfos);
            this.caches.put(fileObject.getAbsolutePath(), configInfos);
        }
        configManager.combineConfig();
        configManager.newInstance();
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(LISTENER_EXT_FILENAMES);
    }
}

