/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.filter.gzip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.weblayer.filter.gzip.CacheResponseWrapper;

public class CacheFilter
implements Filter {
    ServletContext sc;
    FilterConfig fc;
    long cacheTimeout = Long.MAX_VALUE;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        File file;
        HttpServletResponse response;
        HttpServletRequest request;
        block9: {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
            String r = this.sc.getRealPath("");
            String path = this.fc.getInitParameter(request.getRequestURI());
            if (path != null && path.equals("nocache")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            path = r + path;
            String id = request.getRequestURI() + request.getQueryString();
            String localeSensitive = this.fc.getInitParameter("locale-sensitive");
            if (localeSensitive != null) {
                StringWriter ldata = new StringWriter();
                Enumeration locales = request.getLocales();
                while (locales.hasMoreElements()) {
                    Locale locale = (Locale)locales.nextElement();
                    ldata.write(locale.getISO3Language());
                }
                id = id + ldata.toString();
            }
            File tempDir = (File)this.sc.getAttribute("javax.servlet.context.tempdir");
            String temp = tempDir.getAbsolutePath();
            file = new File(temp + id);
            File current = new File(path);
            try {
                long now = Calendar.getInstance().getTimeInMillis();
                if (!file.exists() || file.exists() && current.lastModified() > file.lastModified() || this.cacheTimeout < now - file.lastModified()) {
                    String name;
                    name = name.substring(0, (name = file.getAbsolutePath()).lastIndexOf("/") == -1 ? 0 : name.lastIndexOf("/"));
                    new File(name).mkdirs();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    CacheResponseWrapper wrappedResponse = new CacheResponseWrapper(response, baos);
                    chain.doFilter(req, (ServletResponse)wrappedResponse);
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(baos.toByteArray());
                    fos.flush();
                    fos.close();
                }
            }
            catch (ServletException e) {
                if (!file.exists()) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (IOException e) {
                if (file.exists()) break block9;
                throw e;
            }
        }
        FileInputStream fis = new FileInputStream(file);
        String mt = this.sc.getMimeType(request.getRequestURI());
        response.setContentType(mt);
        ServletOutputStream sos = res.getOutputStream();
        int i = fis.read();
        while (i != -1) {
            sos.write((int)((byte)i));
            i = fis.read();
        }
    }

    public void init(FilterConfig filterConfig) {
        this.fc = filterConfig;
        String ct = this.fc.getInitParameter("cacheTimeout");
        if (ct != null) {
            this.cacheTimeout = 60000L * Long.parseLong(ct);
        }
        this.sc = filterConfig.getServletContext();
    }

    public void destroy() {
        this.sc = null;
        this.fc = null;
    }
}

