/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.filter.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.Configuration;
import org.tinygroup.weblayer.filter.gzip.GZIPResponseWrapper;
import org.tinygroup.xmlparser.node.XmlNode;

public class GZIPFilter
implements Filter,
Configuration {
    private static final String GZIP_FILTER_NODE_PATH = "/application/gzip-filter";
    protected XmlNode applicationConfig;
    private int maxContentLength;
    private Set<String> excludeContentTypes = new HashSet<String>();

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String ae = request.getHeader("accept-encoding");
            if (ae != null && ae.indexOf("gzip") != -1) {
                GZIPResponseWrapper wrappedResponse = new GZIPResponseWrapper(response);
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                byte[] buff = wrappedResponse.getBufferedBytes();
                if (buff.length > 0) {
                    boolean isLessContentLength = this.maxContentLength == 0 || this.maxContentLength >= buff.length;
                    boolean isExcludeType = this.isExcluedType(response);
                    if (isLessContentLength && !isExcludeType) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        GZIPOutputStream gzip = new GZIPOutputStream(baos);
                        gzip.write(buff);
                        gzip.close();
                        buff = baos.toByteArray();
                        response.setHeader("Content-Encoding", "gzip");
                        response.setContentLength(buff.length);
                    }
                    response.getOutputStream().write(buff);
                }
                return;
            }
            chain.doFilter(req, res);
        }
    }

    private boolean isExcluedType(HttpServletResponse response) {
        boolean isExcludeType = false;
        String contentType = response.getContentType();
        if (contentType != null) {
            for (String type : this.excludeContentTypes) {
                if (contentType.indexOf(type) < 0) continue;
                isExcludeType = true;
            }
        }
        return isExcludeType;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public String getApplicationNodePath() {
        return GZIP_FILTER_NODE_PATH;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        if (applicationConfig != null) {
            String value;
            this.maxContentLength = Integer.parseInt(StringUtil.defaultIfBlank((String)applicationConfig.getAttribute("max-content-length"), (String)"0"));
            Assert.assertTrue((this.maxContentLength >= 0 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u957f\u5ea6\u503c\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6b63\u6574\u6570", (Object[])new Object[0]);
            XmlNode excludeNode = (XmlNode)applicationConfig.getSubNode("exclude-content-type");
            if (excludeNode != null && (value = excludeNode.getContent()) != null) {
                String[] types;
                for (String type : types = value.split(";")) {
                    this.excludeContentTypes.add(type);
                }
            }
        }
    }

    public XmlNode getComponentConfig() {
        return null;
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }
}

