/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodeingHttpFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(EncodeingHttpFilter.class);
    private List<String> extNames = new ArrayList<String>();
    private String encoding;
    private boolean enable = true;
    private String contentType;

    public List<String> getExtNames() {
        return this.extNames;
    }

    public void setExtNames(List<String> extNames) {
        this.extNames = extNames;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.extNames.addAll(Arrays.asList("page,pagelet,html,htm,css,flow,js".split(",")));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response;
        HttpServletRequest request;
        block3: {
            request = (HttpServletRequest)servletRequest;
            response = (HttpServletResponse)servletResponse;
            try {
                if (this.encoding == null || !this.enable) break block3;
                String uri = request.getRequestURI();
                for (String extName : this.extNames) {
                    if (!uri.endsWith("." + extName)) continue;
                    request.setCharacterEncoding(this.encoding);
                    logger.logMessage(LogLevel.DEBUG, "\u7f16\u7801\u8bbe\u7f6e\u4e3a\uff1a{}", new Object[]{this.encoding});
                    response.setContentType(this.contentType);
                    break;
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.errorMessage("\u8bbe\u7f6e\u7f16\u7801\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

