/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.TinyFilterHandler;
import org.tinygroup.weblayer.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyFilterChain
implements FilterChain {
    private List<Filter> filters = new ArrayList<Filter>();
    private int size;
    private int currentPosition = 0;
    private static final Logger logger = LoggerFactory.getLogger(TinyFilterChain.class);
    private TinyFilterHandler tinyFilterHandler;

    public TinyFilterChain(List<Filter> filters, TinyFilterHandler hander) {
        this.filters = filters;
        this.size = filters.size();
        this.tinyFilterHandler = hander;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.currentPosition < this.size) {
            Filter nextFilter = this.filters.get(this.currentPosition);
            logger.logMessage(LogLevel.DEBUG, "firing Filter:'{}'", new Object[]{nextFilter.getClass().getSimpleName()});
            ++this.currentPosition;
            nextFilter.doFilter(request, response, (FilterChain)this);
        } else {
            this.initWebContext(request, response);
            this.tinyFilterHandler.tinyFilterProcessor((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    private void initWebContext(ServletRequest request, ServletResponse response) {
        WebContext webContext = this.tinyFilterHandler.getContext();
        webContext.setRequest((HttpServletRequest)request);
        webContext.setResponse((HttpServletResponse)response);
    }
}

