/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext;

import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.TinyFilterHandler;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManager;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManagerHolder;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.weblayer.webcontext.AbstractRequestWrapper;
import org.tinygroup.weblayer.webcontext.CommitMonitor;
import org.tinygroup.weblayer.webcontext.CommittingAwareResponse;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteWebContext;
import org.tinygroup.weblayer.webcontext.util.WebContextUtil;

public class SimpleWebContext
extends CommitMonitor
implements WebContext {
    private static final Logger logger = LoggerFactory.getLogger(SimpleWebContext.class);

    public SimpleWebContext(WebContext webContext, TinyFilterHandler handler, HttpServletRequest request, HttpServletResponse response) {
        super(webContext, handler);
        this.setRequest((HttpServletRequest)new RequestWrapper(request));
        this.setResponse((HttpServletResponse)new CommittingAwareResponse(response, this));
    }

    public void prepare() {
    }

    public void commit() {
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("request", (Object)this.getRequest());
        mb.append("response", (Object)this.getResponse());
        mb.append("webapp", (Object)this.getServletContext());
        return new ToStringBuilder().append((Object)this.getClass().getSimpleName()).append((Object)mb).toString();
    }

    private class RequestWrapper
    extends AbstractRequestWrapper {
        public RequestWrapper(HttpServletRequest request) {
            super(SimpleWebContext.this, request);
        }

        public Object getAttribute(String name) {
            WebContext topWebContext;
            Object object = super.getAttribute(name);
            if (object == null && (topWebContext = SimpleWebContext.this.getTopWebContext()) != null) {
                object = SimpleWebContext.this.getFromWrapperContext(name, SimpleWebContext.this.getTopWebContext());
            }
            return object;
        }

        public Enumeration getAttributeNames() {
            return super.getAttributeNames();
        }

        public void setAttribute(String name, Object value) {
            Object oldValue = this.getAttribute(name);
            super.setAttribute(name, value);
            this.setAttributeListener(name, value, oldValue);
        }

        private void setAttributeListener(String name, Object newValue, Object oldValue) {
            TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
            List<ServletRequestAttributeListener> listeners = configManager.getRequestAttributeListeners();
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(ServletContextHolder.getServletContext(), (ServletRequest)this, name, newValue);
            if (oldValue == null) {
                for (ServletRequestAttributeListener listener : listeners) {
                    logger.logMessage(LogLevel.DEBUG, "ServletRequestAttributeListener:[{0}] will be attributeAdded", new Object[]{listener});
                    listener.attributeAdded(event);
                    logger.logMessage(LogLevel.DEBUG, "ServletRequestAttributeListener:[{0}] attributeAdded", new Object[]{listener});
                }
            } else {
                for (ServletRequestAttributeListener listener : listeners) {
                    logger.logMessage(LogLevel.DEBUG, "ServletRequestAttributeListener:[{0}] will be attributeReplaced,the oldValue:[{1}]", new Object[]{listener, oldValue});
                    listener.attributeReplaced(event);
                    logger.logMessage(LogLevel.DEBUG, "ServletRequestAttributeListener:[{0}] attributeReplaced", new Object[]{listener});
                }
            }
        }

        public void removeAttribute(String name) {
            super.removeAttribute(name);
            this.removeAttributeListener(name);
        }

        private void removeAttributeListener(String name) {
            TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
            List<ServletRequestAttributeListener> listeners = configManager.getRequestAttributeListeners();
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(ServletContextHolder.getServletContext(), (ServletRequest)this, name, null);
            for (ServletRequestAttributeListener listener : listeners) {
                logger.logMessage(LogLevel.DEBUG, "ServletRequestAttributeListener:[{0}] will be attributeRemoved", new Object[]{listener});
                listener.attributeRemoved(event);
                logger.logMessage(LogLevel.DEBUG, "ServletRequestAttributeListener:[{0}] attributeRemoved", new Object[]{listener});
            }
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            RewriteWebContext webContext = WebContextUtil.findWebContext((HttpServletRequest)this.getRequest(), RewriteWebContext.class);
            if (webContext != null) {
                webContext.setPath(StringUtil.substringBefore((String)path, (String)"?"));
            }
            return super.getRequestDispatcher(path);
        }
    }
}

