/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.lazycommit.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.AbstractResponseWrapper;
import org.tinygroup.weblayer.webcontext.AbstractWebContextWrapper;
import org.tinygroup.weblayer.webcontext.lazycommit.LazyCommitWebContext;
import org.tinygroup.weblayer.webcontext.lazycommit.exception.LazyCommitFailedException;

public class LazyCommitWebContextImpl
extends AbstractWebContextWrapper
implements LazyCommitWebContext {
    private static final Logger log = LoggerFactory.getLogger(LazyCommitWebContext.class);
    private SendError sendError;
    private String sendRedirect;
    private boolean setLocation;
    private boolean bufferFlushed;
    private int status;

    public LazyCommitWebContextImpl(WebContext wrappedContext) {
        super(wrappedContext);
        this.setResponse((HttpServletResponse)new ResponseWrapper(wrappedContext.getResponse()));
    }

    public boolean isError() {
        return this.sendError != null;
    }

    public int getErrorStatus() {
        if (this.sendError != null) {
            return this.sendError.status;
        }
        return 0;
    }

    public String getErrorMessage() {
        if (this.sendError != null) {
            return this.sendError.message;
        }
        return null;
    }

    public boolean isRedirected() {
        return this.setLocation || !StringUtil.isEmpty((String)this.sendRedirect);
    }

    public String getRedirectLocation() {
        return this.sendRedirect;
    }

    public int getStatus() {
        return this.status;
    }

    public void commitHeaders() throws LazyCommitFailedException {
        try {
            ((ResponseWrapper)this.getResponse()).commitHeaders();
        }
        catch (IOException e) {
            throw new LazyCommitFailedException(e);
        }
    }

    public void commit() throws LazyCommitFailedException {
        try {
            ((ResponseWrapper)this.getResponse()).commit();
        }
        catch (IOException e) {
            throw new LazyCommitFailedException(e);
        }
    }

    public boolean isRequestFinished() {
        return this.isRedirected();
    }

    private class SendError {
        public final int status;
        public final String message;

        public SendError(int status, String message) {
            this.status = status;
            this.message = message;
        }
    }

    private class ResponseWrapper
    extends AbstractResponseWrapper {
        private boolean headersCommitted;

        public ResponseWrapper(HttpServletResponse response) {
            super(LazyCommitWebContextImpl.this, response);
        }

        public void sendError(int status) throws IOException {
            this.sendError(status, null);
        }

        public void sendError(int status, String message) throws IOException {
            if (LazyCommitWebContextImpl.this.sendError == null && LazyCommitWebContextImpl.this.sendRedirect == null) {
                LazyCommitWebContextImpl.this.sendError = new SendError(status, message);
                if (this.headersCommitted) {
                    super.sendError(status, message);
                }
            }
        }

        public void sendRedirect(String location) throws IOException {
            if (LazyCommitWebContextImpl.this.sendError == null && LazyCommitWebContextImpl.this.sendRedirect == null) {
                LazyCommitWebContextImpl.this.sendRedirect = location;
                if (this.headersCommitted) {
                    super.sendRedirect(location);
                }
            }
        }

        public void setHeader(String key, String value) {
            if ("location".equalsIgnoreCase(key)) {
                LazyCommitWebContextImpl.this.setLocation = true;
            }
            super.setHeader(key, value);
        }

        public void flushBuffer() throws IOException {
            LazyCommitWebContextImpl.this.bufferFlushed = true;
            if (this.headersCommitted) {
                super.flushBuffer();
            }
        }

        public void setStatus(int sc) {
            LazyCommitWebContextImpl.this.status = sc;
            if (this.headersCommitted) {
                super.setStatus(sc);
            }
        }

        public void reset() {
            super.reset();
            LazyCommitWebContextImpl.this.sendError = null;
            LazyCommitWebContextImpl.this.sendRedirect = null;
            LazyCommitWebContextImpl.this.setLocation = false;
            LazyCommitWebContextImpl.this.bufferFlushed = false;
            LazyCommitWebContextImpl.this.status = 0;
        }

        private void commitHeaders() throws IOException {
            this.headersCommitted = true;
            if (LazyCommitWebContextImpl.this.status > 0) {
                log.logMessage(LogLevel.DEBUG, "Set HTTP status to {}", new Object[]{LazyCommitWebContextImpl.this.status});
                super.setStatus(LazyCommitWebContextImpl.this.status);
            }
            if (LazyCommitWebContextImpl.this.sendError != null) {
                if (((LazyCommitWebContextImpl)LazyCommitWebContextImpl.this).sendError.message == null) {
                    log.logMessage(LogLevel.DEBUG, "Set error page:  {}", new Object[]{((LazyCommitWebContextImpl)LazyCommitWebContextImpl.this).sendError.status});
                    super.sendError(((LazyCommitWebContextImpl)LazyCommitWebContextImpl.this).sendError.status);
                } else {
                    log.logMessage(LogLevel.DEBUG, "Set error page: {} {}", new Object[]{((LazyCommitWebContextImpl)LazyCommitWebContextImpl.this).sendError.status, ((LazyCommitWebContextImpl)LazyCommitWebContextImpl.this).sendError.message});
                    super.sendError(((LazyCommitWebContextImpl)LazyCommitWebContextImpl.this).sendError.status, ((LazyCommitWebContextImpl)LazyCommitWebContextImpl.this).sendError.message);
                }
            } else if (LazyCommitWebContextImpl.this.sendRedirect != null) {
                log.logMessage(LogLevel.DEBUG, "Set redirect location to {}", new Object[]{LazyCommitWebContextImpl.this.sendRedirect});
                String charset = this.getCharacterEncoding();
                if (charset != null) {
                    LazyCommitWebContextImpl.this.sendRedirect = new String(LazyCommitWebContextImpl.this.sendRedirect.getBytes(charset), "8859_1");
                }
                super.sendRedirect(LazyCommitWebContextImpl.this.sendRedirect);
            }
        }

        private void commit() throws IOException {
            if (LazyCommitWebContextImpl.this.bufferFlushed) {
                super.flushBuffer();
            }
        }
    }
}

