/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.impl.AbstractFileObject;
import org.tinygroup.weblayer.webcontext.parser.impl.DiskFileItem;
import org.tinygroup.weblayer.webcontext.parser.impl.ItemFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileObjectInDisk
extends AbstractFileObject
implements ItemFileObject {
    private DiskFileItem fileItem;
    private static final String FILE_PROTOCAL = "file:";

    public FileObjectInDisk(DiskFileItem fileItem) {
        super(null);
        this.fileItem = fileItem;
    }

    public String getFileName() {
        File file = this.fileItem.getStoreLocation();
        if (file != null) {
            return file.getName();
        }
        return null;
    }

    public String getPath() {
        String repository = this.fileItem.getRepository().getAbsolutePath();
        String filePath = this.getAbsolutePath();
        if (filePath != null && filePath.startsWith(repository)) {
            return this.resolverFilePath(filePath, repository);
        }
        return "/";
    }

    private String resolverFilePath(String filePath, String separator) {
        String path = StringUtil.substringAfterLast((String)filePath, (String)separator);
        return StringUtil.replace((String)path, (String)"\\", (String)"/");
    }

    public String getAbsolutePath() {
        File file = this.fileItem.getStoreLocation();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public String getExtName() {
        File file = this.fileItem.getStoreLocation();
        if (file != null) {
            return FileUtil.getExtension((String)file.getName());
        }
        return null;
    }

    public boolean isExist() {
        File file = this.fileItem.getStoreLocation();
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public InputStream getInputStream() {
        try {
            return this.fileItem.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u8f93\u5165\u6d41\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    public boolean isFolder() {
        File file = this.fileItem.getStoreLocation();
        if (file != null) {
            return file.isDirectory();
        }
        return false;
    }

    public List<FileObject> getChildren() {
        return null;
    }

    public FileObject getChild(String fileName) {
        return null;
    }

    public long getLastModifiedTime() {
        return 0L;
    }

    public boolean isInPackage() {
        return false;
    }

    public URL getURL() {
        try {
            return new URL(FILE_PROTOCAL + this.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.fileItem.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u8f93\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    @Override
    public FileItem getFileItem() {
        return this.fileItem;
    }
}

