/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.support.BeanSupport;
import org.tinygroup.weblayer.webcontext.parser.impl.HTMLInputFilter;
import org.tinygroup.weblayer.webcontext.parser.upload.ParameterValueFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLParameterValueFilter
extends BeanSupport
implements ParameterValueFilter {
    private HTMLInputFilter filter;
    private Map<String, Set<String>> allowed;
    private String[] deniedTags;
    private String[] selfClosingTags;
    private String[] needClosingTags;
    private String[] allowedProtocols;
    private String[] protocolAtts;
    private String[] removeBlanks;
    private String[] allowedEntities;

    protected void init() {
        if (this.allowed == null) {
            this.allowed = CollectionUtil.createHashMap();
        }
        this.deniedTags = (String[])ObjectUtil.defaultIfNull((Object)this.deniedTags, (Object)BasicConstant.EMPTY_STRING_ARRAY);
        this.selfClosingTags = (String[])ObjectUtil.defaultIfNull((Object)this.selfClosingTags, (Object)BasicConstant.EMPTY_STRING_ARRAY);
        this.needClosingTags = (String[])ObjectUtil.defaultIfNull((Object)this.needClosingTags, (Object)BasicConstant.EMPTY_STRING_ARRAY);
        this.allowedProtocols = (String[])ObjectUtil.defaultIfNull((Object)this.allowedProtocols, (Object)BasicConstant.EMPTY_STRING_ARRAY);
        this.protocolAtts = (String[])ObjectUtil.defaultIfNull((Object)this.protocolAtts, (Object)BasicConstant.EMPTY_STRING_ARRAY);
        this.removeBlanks = (String[])ObjectUtil.defaultIfNull((Object)this.removeBlanks, (Object)BasicConstant.EMPTY_STRING_ARRAY);
        this.allowedEntities = (String[])ObjectUtil.defaultIfNull((Object)this.allowedEntities, (Object)BasicConstant.EMPTY_STRING_ARRAY);
        this.filter = new HTMLInputFilter(this.allowed, this.deniedTags, this.selfClosingTags, this.needClosingTags, this.allowedProtocols, this.protocolAtts, this.removeBlanks, this.allowedEntities);
    }

    @Override
    public boolean isFiltering(HttpServletRequest request) {
        return true;
    }

    @Override
    public String filter(String key, String value, boolean isHtml) {
        this.assertInitialized();
        if (value == null) {
            return null;
        }
        return this.filter.filter(value, isHtml);
    }

    public HTMLInputFilter getFilter() {
        return this.filter;
    }

    public void setFilter(HTMLInputFilter filter) {
        this.filter = filter;
    }

    public Map<String, Set<String>> getAllowed() {
        return this.allowed;
    }

    public void setAllowed(Map<String, Set<String>> allowed) {
        this.allowed = allowed;
    }

    public String[] getDeniedTags() {
        return this.deniedTags;
    }

    public void setDeniedTags(String[] deniedTags) {
        this.deniedTags = deniedTags;
    }

    public String[] getSelfClosingTags() {
        return this.selfClosingTags;
    }

    public void setSelfClosingTags(String[] selfClosingTags) {
        this.selfClosingTags = selfClosingTags;
    }

    public String[] getNeedClosingTags() {
        return this.needClosingTags;
    }

    public void setNeedClosingTags(String[] needClosingTags) {
        this.needClosingTags = needClosingTags;
    }

    public String[] getAllowedProtocols() {
        return this.allowedProtocols;
    }

    public void setAllowedProtocols(String[] allowedProtocols) {
        this.allowedProtocols = allowedProtocols;
    }

    public String[] getProtocolAtts() {
        return this.protocolAtts;
    }

    public void setProtocolAtts(String[] protocolAtts) {
        this.protocolAtts = protocolAtts;
    }

    public String[] getRemoveBlanks() {
        return this.removeBlanks;
    }

    public void setRemoveBlanks(String[] removeBlanks) {
        this.removeBlanks = removeBlanks;
    }

    public String[] getAllowedEntities() {
        return this.allowedEntities;
    }

    public void setAllowedEntities(String[] allowedEntities) {
        this.allowedEntities = allowedEntities;
    }
}

