/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.valueparser;

import java.beans.PropertyEditor;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.core.MethodParameter;
import org.tinygroup.beanwrapper.BeanWrapperHolder;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.webcontext.parser.ParserWebContext;
import org.tinygroup.weblayer.webcontext.parser.StringFileItemEditor;
import org.tinygroup.weblayer.webcontext.parser.valueparser.ValueList;
import org.tinygroup.weblayer.webcontext.parser.valueparser.ValueParser;
import org.tinygroup.weblayer.webcontext.parser.valueparser.impl.ValueListSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValueParser
implements ValueParser {
    protected static Logger logger = LoggerFactory.getLogger(AbstractValueParser.class);
    protected final SimpleTypeConverter converter;
    protected final Map<String, Object> parameters = CollectionUtil.createLinkedHashMap();
    protected final Map<String, String> parameterKeys = CollectionUtil.createLinkedHashMap();
    protected final ParserWebContext webContext;

    public AbstractValueParser(ParserWebContext requestContext) {
        this.webContext = requestContext;
        this.converter = new SimpleTypeConverter();
        this.converter.registerCustomEditor(String.class, (PropertyEditor)new StringFileItemEditor());
        if (requestContext.getPropertyEditorRegistrar() != null) {
            requestContext.getPropertyEditorRegistrar().registerCustomEditors((PropertyEditorRegistry)this.converter);
        }
    }

    @Override
    public TypeConverter getTypeConverter() {
        return this.converter;
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.parameters.containsKey(this.convert(key));
    }

    @Override
    public Set<String> keySet() {
        return CollectionUtil.createLinkedHashSet(this.parameterKeys.values());
    }

    @Override
    public String[] getKeys() {
        return this.parameterKeys.values().toArray(new String[this.parameterKeys.size()]);
    }

    @Override
    public boolean getBoolean(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? false : container.getBooleanValue();
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getBooleanValue(defaultValue);
    }

    @Override
    public byte getByte(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? (byte)0 : container.getByteValue();
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getByteValue(defaultValue);
    }

    @Override
    public byte[] getBytes(String key) throws UnsupportedEncodingException {
        ValueList container = this.getValueList(key, false);
        return container == null ? BasicConstant.EMPTY_BYTE_ARRAY : container.getBytes(this.getCharacterEncoding());
    }

    @Override
    public char getChar(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? (char)'\u0000' : container.getCharacterValue();
    }

    @Override
    public char getChar(String key, char defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getCharacterValue(Character.valueOf(defaultValue));
    }

    @Override
    public double getDouble(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? 0.0 : container.getDoubleValue();
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getDoubleValue(defaultValue);
    }

    @Override
    public float getFloat(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? 0.0f : container.getFloatValue();
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getFloatValue(Float.valueOf(defaultValue));
    }

    @Override
    public int getInt(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? 0 : container.getIntegerValue();
    }

    @Override
    public int getInt(String key, int defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getIntegerValue(defaultValue);
    }

    @Override
    public int[] getInts(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? BasicConstant.EMPTY_INT_ARRAY : container.getIntegerValues();
    }

    @Override
    public int[] getInts(String key, int[] defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getIntegerValues(defaultValue);
    }

    @Override
    public long getLong(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? 0L : container.getLongValue();
    }

    @Override
    public long getLong(String key, long defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getLongValue(defaultValue);
    }

    @Override
    public long[] getLongs(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? BasicConstant.EMPTY_LONG_ARRAY : container.getLongValues();
    }

    @Override
    public long[] getLongs(String key, long[] defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getLongValues(defaultValue);
    }

    @Override
    public short getShort(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? (short)0 : container.getShortValue();
    }

    @Override
    public short getShort(String key, short defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getShortValue(defaultValue);
    }

    @Override
    public String getString(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? null : container.getStringValue();
    }

    @Override
    public String getString(String key, String defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getStringValue(defaultValue);
    }

    @Override
    public String[] getStrings(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? BasicConstant.EMPTY_STRING_ARRAY : container.getStringValues();
    }

    @Override
    public String[] getStrings(String key, String[] defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getStringValues(defaultValue);
    }

    @Override
    public Object get(String key) {
        return this.getObject(key);
    }

    @Override
    public Date getDate(String key, DateFormat format) {
        ValueList container = this.getValueList(key, false);
        return container == null ? null : container.getDateValue(format);
    }

    @Override
    public Date getDate(String key, DateFormat format, Date defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getDateValue(format, defaultValue);
    }

    @Override
    public Object getObject(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? null : container.getValue();
    }

    @Override
    public Object getObject(String key, Object defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getValue(defaultValue);
    }

    @Override
    public Object[] getObjects(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? BasicConstant.EMPTY_OBJECT_ARRAY : container.getValues();
    }

    @Override
    public Object[] getObjects(String key, Object[] defaultValue) {
        ValueList container = this.getValueList(key, false);
        return container == null ? defaultValue : container.getValues(defaultValue);
    }

    @Override
    public <T> T getObjectOfType(String key, Class<T> type) {
        return this.getObjectOfType(key, type, null, null);
    }

    @Override
    public <T> T getObjectOfType(String key, Class<T> type, MethodParameter methodParameter, Object[] defaultValues) {
        return this.getObjectOfType(key, type, false, methodParameter, defaultValues);
    }

    <T> T getObjectOfType(String key, Class<T> type, boolean isPrimitive, MethodParameter methodParameter, Object[] defaultValues) {
        ValueList container = this.getValueList(key, false);
        if (container == null) {
            container = new ValueListSupport(this.getTypeConverter(), this.webContext.isConverterQuiet());
            if (!ArrayUtil.isEmptyArray((Object)defaultValues)) {
                for (Object value : defaultValues) {
                    container.addValue(value);
                }
            }
            defaultValues = null;
        }
        return container.getValueOfType(type, isPrimitive, methodParameter, defaultValues);
    }

    @Override
    public void setProperties(Object object) {
        if (object == null) {
            return;
        }
        logger.logMessage(LogLevel.DEBUG, "Set HTTP request parameters to object {}", new Object[]{ObjectUtil.identityToString((Object)object)});
        BeanWrapper bean = BeanWrapperHolder.getInstance().getBeanWrapper(object);
        this.webContext.getPropertyEditorRegistrar().registerCustomEditors((PropertyEditorRegistry)bean);
        for (String key : this.keySet()) {
            String propertyName = StringUtil.toCamelCase((String)key);
            if (bean.isWritableProperty(propertyName)) {
                bean.setPropertyValue(propertyName, (Object)this.getString(key));
                continue;
            }
            logger.logMessage(LogLevel.DEBUG, "No writable property \"{}\" found in type {}", new Object[]{propertyName, object.getClass().getName()});
        }
    }

    @Override
    public void add(String key, boolean value) {
        this.getValueList(key, true).addValue(value);
    }

    @Override
    public void add(String key, byte value) {
        this.getValueList(key, true).addValue(value);
    }

    @Override
    public void add(String key, char value) {
        this.getValueList(key, true).addValue(value);
    }

    @Override
    public void add(String key, double value) {
        this.getValueList(key, true).addValue(value);
    }

    @Override
    public void add(String key, float value) {
        this.getValueList(key, true).addValue(value);
    }

    @Override
    public void add(String key, int value) {
        this.getValueList(key, true).addValue(value);
    }

    @Override
    public void add(String key, long value) {
        this.getValueList(key, true).addValue(value);
    }

    @Override
    public void add(String key, short value) {
        this.getValueList(key, true).addValue(value);
    }

    @Override
    public void add(String key, Object value) {
        this.getValueList(key, true).addValue(value);
    }

    public void remove(String key, Object value) {
        this.getValueList(key, true).removeValue(value);
    }

    @Override
    public void setString(String key, String value) {
        this.setObject(key, value);
    }

    @Override
    public void setStrings(String key, String[] values) {
        this.setObjects(key, values);
    }

    @Override
    public void setObject(String key, Object value) {
        this.getValueList(key, true).setValue(value);
    }

    @Override
    public void setObjects(String key, Object[] values) {
        this.getValueList(key, true).setValues(values);
    }

    @Override
    public Object remove(String key) {
        key = this.convert(key);
        this.parameterKeys.remove(key);
        return this.parameters.remove(key);
    }

    @Override
    public void clear() {
        this.parameterKeys.clear();
        this.parameters.clear();
    }

    protected String convert(String key) {
        if (this.webContext == null) {
            return key;
        }
        return this.webContext.convertCase(key);
    }

    protected ValueList getValueList(String key, boolean create) {
        String originalKey = key;
        key = this.convert(key);
        ValueList container = (ValueList)this.parameters.get(key);
        if (create) {
            if (container == null) {
                container = new ValueListSupport(this.getTypeConverter(), this.webContext.isConverterQuiet());
                this.parameterKeys.put(key, originalKey);
                this.parameters.put(key, container);
            }
            return container;
        }
        if (container == null || container.size() == 0) {
            return null;
        }
        return container;
    }

    protected String getCharacterEncoding() {
        return "ISO-8859-1";
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder().setSortKeys(true);
        for (String key : this.parameterKeys.values()) {
            mb.append(key, (Object)this.getValueList(key, false));
        }
        return mb.toString();
    }
}

