/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.rewrite;

import java.util.regex.MatchResult;
import javax.servlet.http.HttpServletRequest;
import org.tinygroup.commons.tools.MatchResultSubstitution;
import org.tinygroup.format.FormatProvider;
import org.tinygroup.format.Formater;
import org.tinygroup.format.PatternDefine;
import org.tinygroup.format.impl.DefaultPatternDefine;
import org.tinygroup.format.impl.FormaterImpl;
import org.tinygroup.weblayer.webcontext.parser.ParserWebContext;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteFormatProvider;
import org.tinygroup.weblayer.webcontext.util.WebContextUtil;

public class RewriteUtil {
    private static Formater formatter = new FormaterImpl();
    private static RewriteFormatProvider provider = new RewriteFormatProvider();

    public static boolean isFullURL(String path) {
        return path.matches("^\\w+:.*");
    }

    public static MatchResultSubstitution getMatchResultSubstitution(MatchResult ruleMatchResult, MatchResult conditionMatchResult) {
        return new MatchResultSubstitution("$%", new MatchResult[]{ruleMatchResult, conditionMatchResult});
    }

    public static String getSubstitutedTestString(String testString, MatchResult ruleMatchResult, MatchResult conditionMatchResult, HttpServletRequest request) {
        testString = RewriteUtil.format(testString, request);
        return RewriteUtil.getMatchResultSubstitution(ruleMatchResult, conditionMatchResult).substitute(testString);
    }

    public static String format(String testString, HttpServletRequest request) {
        provider.setRequest(request);
        return formatter.format(null, testString);
    }

    public static String expand(String varName, HttpServletRequest request) {
        String result;
        boolean valid = true;
        if ("REMOTE_HOST".equals(varName)) {
            result = request.getRemoteHost();
        } else if ("REMOTE_ADDR".equals(varName)) {
            result = request.getRemoteAddr();
        } else if ("REMOTE_USER".equals(varName)) {
            result = request.getRemoteUser();
        } else if ("REQUEST_METHOD".equals(varName)) {
            result = request.getMethod();
        } else if ("QUERY_STRING".equals(varName)) {
            if ("post".equalsIgnoreCase(request.getMethod())) {
                ParserWebContext parserRequestContext = WebContextUtil.findWebContext(request, ParserWebContext.class);
                result = parserRequestContext.getParameters().toQueryString();
            } else {
                result = request.getQueryString();
            }
        } else if (varName.startsWith("QUERY:")) {
            ParserWebContext parserRequestContext = WebContextUtil.findWebContext(request, ParserWebContext.class);
            result = parserRequestContext.getParameters().getString(varName.substring("QUERY:".length()).trim());
        } else if ("AUTH_TYPE".equals(varName)) {
            result = request.getAuthType();
        } else if ("SERVER_NAME".equals(varName)) {
            result = request.getServerName();
        } else if ("SERVER_PORT".equals(varName)) {
            result = String.valueOf(request.getServerPort());
        } else if ("SERVER_PROTOCOL".equals(varName)) {
            result = request.getProtocol();
        } else if ("HTTP_USER_AGENT".equals(varName)) {
            result = request.getHeader("User-Agent");
        } else if ("HTTP_REFERER".equals(varName)) {
            result = request.getHeader("Referer");
        } else if ("HTTP_HOST".equals(varName)) {
            result = request.getHeader("Host");
        } else if ("HTTP_ACCEPT".equals(varName)) {
            result = request.getHeader("Accept");
        } else if ("HTTP_COOKIE".equals(varName)) {
            result = request.getHeader("Cookie");
        } else if ("REQUEST_URI".equals(varName)) {
            result = request.getRequestURI();
        } else {
            result = null;
            valid = false;
        }
        if (valid && result == null) {
            result = "";
        }
        return result;
    }

    static {
        DefaultPatternDefine define = new DefaultPatternDefine();
        define.setPrefixPatternString("%{");
        define.setPostfixPatternString("}");
        define.setSplitChar('#');
        define.setPatternString("([%]+[{]+[a-zA-Z0-9[.[_[:[/[#]]]]]]+[}])");
        formatter.setPatternHandle((PatternDefine)define);
        formatter.addFormatProvider("", (FormatProvider)provider);
    }
}

