/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.impl;

import java.util.Map;
import org.tinygroup.commons.tools.ClassUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.webcontext.session.SessionConfig;
import org.tinygroup.weblayer.webcontext.session.impl.AbstractSessionAttributeAccessController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAttributeWhitelist
extends AbstractSessionAttributeAccessController {
    private final Logger log = LoggerFactory.getLogger(SessionAttributeWhitelist.class);
    private Map<String, Class<?>> allowedAttributes;

    public void setAllowedAttributes(Map<String, Class<?>> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    @Override
    public void init(SessionConfig sessionConfig) {
        super.init(sessionConfig);
        if (this.allowedAttributes == null) {
            this.allowedAttributes = CollectionUtil.createHashMap();
        }
        for (Map.Entry<String, Class<?>> entry : this.allowedAttributes.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue(Object.class);
                continue;
            }
            entry.setValue(ClassUtil.getWrapperTypeIfPrimitive(entry.getValue()));
        }
    }

    @Override
    protected boolean allowForAttribute(String name, Class<?> type) {
        Class<?> allowedType = this.allowedAttributes.get(name);
        if (allowedType == null) {
            return false;
        }
        if (type == null) {
            return true;
        }
        return allowedType.isAssignableFrom(type);
    }

    @Override
    protected Object readInvalidAttribute(String name, Object value) {
        this.log.getLogger().warn("Attribute to read is not in whitelist: name={}, type={}", (Object)name, (Object)(value == null ? "unknwon" : value.getClass().getName()));
        return value;
    }

    @Override
    protected Object writeInvalidAttribute(String name, Object value) {
        this.log.getLogger().warn("Attribute to write is not in whitelist: name={}, type={}", (Object)name, (Object)(value == null ? "unknwon" : value.getClass().getName()));
        return value;
    }
}

