/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.setlocacle.impl;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.tinygroup.commons.i18n.LocaleInfo;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.AbstractRequestWrapper;
import org.tinygroup.weblayer.webcontext.AbstractResponseWrapper;
import org.tinygroup.weblayer.webcontext.AbstractWebContextWrapper;
import org.tinygroup.weblayer.webcontext.setlocacle.SetLocaleWebContext;
import org.tinygroup.weblayer.webcontext.setlocacle.impl.SetLocaleOverrider;
import org.tinygroup.weblayer.webcontext.util.ServletUtil;

public class SetLocaleWebContextImpl
extends AbstractWebContextWrapper
implements SetLocaleWebContext {
    protected static Logger log = LoggerFactory.getLogger(SetLocaleWebContextImpl.class);
    private Pattern inputCharsetPattern;
    private Pattern outputCharsetPattern;
    private SetLocaleOverrider[] overriders;
    private Locale defaultLocale;
    private String defaultCharset;
    private String sessionKey;
    private String paramKey;
    private Locale locale;

    public SetLocaleWebContextImpl(WebContext wrappedContext) {
        super(wrappedContext);
        this.setRequest((HttpServletRequest)new RequestWrapper(wrappedContext.getRequest()));
        this.setResponse((HttpServletResponse)new ResponseWrapper(wrappedContext.getResponse()));
    }

    public void setInputCharsetPattern(Pattern inputCharsetPattern) {
        this.inputCharsetPattern = inputCharsetPattern;
    }

    public void setOutputCharsetPattern(Pattern outputCharsetPattern) {
        this.outputCharsetPattern = outputCharsetPattern;
    }

    public void setOverriders(SetLocaleOverrider[] overriders) {
        this.overriders = overriders;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setParamKey(String paramKey) {
        this.paramKey = paramKey;
    }

    public String getResponseContentType() {
        return this.getResponse().getContentType();
    }

    public void setResponseContentType(String contentType, boolean appendCharset) {
        ((ResponseWrapper)this.getResponse()).setContentType(contentType, appendCharset);
    }

    public void setResponseCharacterEncoding(String charset) {
        this.getResponse().setCharacterEncoding(charset);
    }

    public void prepare() {
        LocaleInfo localeInfo = this.getLocaleInfoFromSessionOrGetTheDefaultValue();
        SetLocaleOverrider overrider = this.getMatchedOverrider();
        this.setInputCharsetToRequest(localeInfo.getCharset().name(), overrider);
        if ("default".equalsIgnoreCase(this.getRequest().getParameter(this.paramKey))) {
            localeInfo = this.resetLocaleInfoInSession();
        } else {
            LocaleInfo paramLocale;
            String outputCharset = this.getOutputCharsetFromQueryString();
            if (outputCharset == null) {
                outputCharset = this.getOutputCharsetOverridden(overrider);
            }
            if ((paramLocale = this.getLocaleInfoFromParameter()) != null) {
                this.getRequest().getSession().setAttribute(this.sessionKey, (Object)paramLocale.toString());
                localeInfo = paramLocale;
            }
            if (outputCharset != null) {
                localeInfo = new LocaleInfo(localeInfo.getLocale(), outputCharset);
            }
        }
        this.getResponse().setLocale(localeInfo.getLocale());
        this.setResponseCharacterEncoding(localeInfo.getCharset().name());
        log.logMessage(LogLevel.DEBUG, "Set OUTPUT locale:charset to {}", new Object[]{localeInfo});
        LocaleUtil.setContext((Locale)localeInfo.getLocale(), (String)localeInfo.getCharset().name());
        log.logMessage(LogLevel.DEBUG, "Set THREAD CONTEXT locale:charset to ", new Object[]{localeInfo});
        this.locale = localeInfo.getLocale();
    }

    private SetLocaleOverrider getMatchedOverrider() {
        if (this.overriders != null && this.overriders.length > 0) {
            String path = ServletUtil.getResourcePath(this.getRequest());
            for (SetLocaleOverrider overrider : this.overriders) {
                if (!overrider.getRequestUriPattern().matcher(path).find()) continue;
                return overrider;
            }
        }
        return null;
    }

    private LocaleInfo getLocaleInfoFromSessionOrGetTheDefaultValue() {
        LocaleInfo localeInfo;
        String localeName;
        HttpSession session = this.getRequest().getSession(false);
        String string = localeName = session == null ? null : (String)this.getRequest().getSession().getAttribute(this.sessionKey);
        if (StringUtil.isEmpty(localeName)) {
            localeInfo = new LocaleInfo(this.defaultLocale, this.defaultCharset);
        } else {
            localeInfo = LocaleInfo.parse((String)localeName);
            if (!LocaleUtil.isLocaleSupported((Locale)localeInfo.getLocale()) || !LocaleUtil.isCharsetSupported((String)localeInfo.getCharset().name())) {
                log.logMessage(LogLevel.WARN, "Invalid locale {} from session", new Object[]{localeInfo});
                localeInfo = new LocaleInfo(this.defaultLocale, this.defaultCharset);
            }
        }
        return localeInfo;
    }

    private void setInputCharsetToRequest(String inputCharset, SetLocaleOverrider overrider) {
        try {
            String charset = this.getInputCharsetFromQueryString();
            if (charset == null) {
                charset = this.getInputCharsetOverridden(overrider);
            }
            if (charset != null) {
                inputCharset = charset;
            }
            this.getRequest().setCharacterEncoding(inputCharset);
            log.logMessage(LogLevel.DEBUG, "Set INPUT charset to " + inputCharset);
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.getRequest().setCharacterEncoding("UTF-8");
                log.logMessage(LogLevel.WARN, "Unknown charset {}.  Set INPUT charset to {}", new Object[]{inputCharset, "UTF-8"});
            }
            catch (UnsupportedEncodingException ee) {
                log.errorMessage("Failed to set INPUT charset to {}", (Throwable)ee, new Object[]{"UTF-8"});
            }
        }
    }

    private String getInputCharsetFromQueryString() {
        Matcher matcher;
        String inputCharsetQS = null;
        String queryString = this.getRequest().getQueryString();
        if (queryString != null && (matcher = this.inputCharsetPattern.matcher(queryString)).find()) {
            String charset = null;
            if (matcher.groupCount() >= 2) {
                charset = matcher.group(2);
            }
            if (LocaleUtil.isCharsetSupported(charset)) {
                inputCharsetQS = charset;
            } else {
                log.logMessage(LogLevel.WARN, "Specified input charset is not supported: {}", new Object[]{charset});
            }
        }
        return inputCharsetQS;
    }

    private String getInputCharsetOverridden(SetLocaleOverrider overrider) {
        String charset;
        String inputCharsetOverridden = null;
        if (overrider != null && (charset = overrider.getInputCharset()) != null) {
            if (LocaleUtil.isCharsetSupported((String)charset)) {
                inputCharsetOverridden = charset;
            } else {
                log.logMessage(LogLevel.WARN, "Specified overridden input charset is not supported: {}", new Object[]{charset});
            }
        }
        return inputCharsetOverridden;
    }

    private LocaleInfo resetLocaleInfoInSession() {
        HttpSession session = this.getRequest().getSession(false);
        if (session != null) {
            session.removeAttribute(this.sessionKey);
        }
        LocaleInfo localeInfo = new LocaleInfo(this.defaultLocale, this.defaultCharset);
        log.logMessage(LogLevel.DEBUG, "Reset OUTPUT locale:charset to {}", new Object[]{localeInfo});
        return localeInfo;
    }

    private String getOutputCharsetFromQueryString() {
        Matcher matcher;
        String queryString = this.getRequest().getQueryString();
        String outputCharsetQS = null;
        if (queryString != null && (matcher = this.outputCharsetPattern.matcher(queryString)).find()) {
            String charset = null;
            if (matcher.groupCount() >= 2) {
                charset = matcher.group(2);
            }
            if (LocaleUtil.isCharsetSupported(charset)) {
                outputCharsetQS = charset;
            } else {
                log.logMessage(LogLevel.WARN, "Specified output charset is not supported: {}", new Object[]{charset});
            }
        }
        return outputCharsetQS;
    }

    private String getOutputCharsetOverridden(SetLocaleOverrider overrider) {
        String charset;
        String outputCharsetOverridden = null;
        if (overrider != null && (charset = overrider.getOutputCharset()) != null) {
            if (LocaleUtil.isCharsetSupported((String)charset)) {
                outputCharsetOverridden = charset;
            } else {
                log.logMessage(LogLevel.WARN, "Specified overridden output charset is not supported: {}", new Object[]{charset});
            }
        }
        return outputCharsetOverridden;
    }

    private LocaleInfo getLocaleInfoFromParameter() {
        String localeName = this.getRequest().getParameter(this.paramKey);
        LocaleInfo localeInfo = null;
        if (!(StringUtil.isEmpty((String)localeName) || LocaleUtil.isLocaleSupported((Locale)(localeInfo = LocaleInfo.parse((String)localeName)).getLocale()) && LocaleUtil.isCharsetSupported((String)localeInfo.getCharset().name()))) {
            log.logMessage(LogLevel.WARN, "Invalid locale {} from request parameters", new Object[]{localeInfo});
            localeInfo = new LocaleInfo(this.defaultLocale, this.defaultCharset);
        }
        return localeInfo;
    }

    private class ResponseWrapper
    extends AbstractResponseWrapper {
        private String contentType;
        private String charset;

        public ResponseWrapper(HttpServletResponse response) {
            super(SetLocaleWebContextImpl.this, response);
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.setContentType(contentType, true);
        }

        public void setContentType(String contentType, boolean appendCharset) {
            String charset = StringUtil.trimToNull((String)StringUtil.substringAfterLast((String)contentType, (String)"charset="));
            if (charset == null) {
                charset = this.charset;
            }
            this.contentType = StringUtil.trimToNull((String)StringUtil.substringBefore((String)contentType, (String)";"));
            this.setCharacterEncoding(appendCharset ? charset : null);
        }

        public String getCharacterEncoding() {
            return super.getCharacterEncoding();
        }

        public void setCharacterEncoding(String charset) {
            this.charset = charset;
            if (this.contentType != null) {
                this.contentType = StringUtil.trimToNull((String)StringUtil.substringBefore((String)this.contentType, (String)";"));
                if (charset != null) {
                    this.contentType = this.contentType + "; charset=" + charset;
                }
                log.logMessage(LogLevel.DEBUG, "Set content type to {}", new Object[]{this.contentType});
                super.setContentType(this.contentType);
            } else {
                try {
                    super.setCharacterEncoding(charset);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }

    private class RequestWrapper
    extends AbstractRequestWrapper {
        public RequestWrapper(HttpServletRequest request) {
            super(SetLocaleWebContextImpl.this, request);
        }

        public Locale getLocale() {
            return SetLocaleWebContextImpl.this.locale == null ? super.getLocale() : SetLocaleWebContextImpl.this.locale;
        }
    }
}

