/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.FilterHandler;
import org.tinygroup.weblayer.TinyFilter;
import org.tinygroup.weblayer.TinyFilterManager;
import org.tinygroup.weblayer.TinyProcessorManager;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.exceptionhandler.WebExceptionHandlerManager;
import org.tinygroup.weblayer.webcontext.CommitMonitor;
import org.tinygroup.weblayer.webcontext.SimpleWebContext;
import org.tinygroup.weblayer.webcontext.TwoPhaseCommitWebContext;
import org.tinygroup.weblayer.webcontext.buffered.BufferedWebContext;
import org.tinygroup.weblayer.webcontext.parser.ParserWebContext;
import org.tinygroup.weblayer.webcontext.util.QueryStringParser;
import org.tinygroup.weblayer.webcontext.util.WebContextUtil;

public class TinyFilterHandler
implements FilterHandler {
    private static final String SEARCH_STR = "?";
    private static final Logger logger = LoggerFactory.getLogger(TinyFilterHandler.class);
    private static final String WEB_CONTEXT_OWNER_KEY = "_web_context_owner_";
    private TinyFilterManager tinyFilterManager;
    private TinyProcessorManager tinyProcessorManager;
    private FilterChain filterChain;
    private String servletPath;
    private WebContext context;
    private List<Pattern> passthruPatterns;

    public TinyFilterHandler(String servletPath, FilterChain filterChain, WebContext context, TinyFilterManager tinyFilterManager, TinyProcessorManager tinyProcessorManager, List<Pattern> passthruPatterns) {
        this.context = context;
        this.filterChain = filterChain;
        this.servletPath = servletPath;
        this.tinyFilterManager = tinyFilterManager;
        this.tinyProcessorManager = tinyProcessorManager;
        this.passthruPatterns = passthruPatterns;
    }

    public WebContext getContext() {
        return this.context;
    }

    public void setContext(WebContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tinyFilterProcessor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        WebContext wrapperContext;
        List tinyFilters;
        block7: {
            logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84\uff1a<{}>", new Object[]{this.servletPath});
            tinyFilters = this.tinyFilterManager.getTinyFiltersWithUrl(this.servletPath);
            wrapperContext = null;
            wrapperContext = this.getWebContext(this.context, tinyFilters, request, response);
            if (!this.isRequestFinished(tinyFilters.size(), wrapperContext)) break block7;
            this.postProcess(wrapperContext, tinyFilters);
            return;
        }
        try {
            this.servletPath = this.getServletPath(wrapperContext.getRequest(), wrapperContext);
            if (this.isRequestPassedThru(this.servletPath) || !this.tinyProcessorManager.execute(this.servletPath, wrapperContext)) {
                this.giveUpControl(wrapperContext);
                this.postProcess(wrapperContext, tinyFilters);
                return;
            }
            this.postProcess(wrapperContext, tinyFilters);
        }
        catch (Exception e) {
            try {
                if (wrapperContext == null) {
                    wrapperContext = WebContextUtil.getWebContext((HttpServletRequest)request);
                }
                this.handleException(wrapperContext, e, this.context.getRequest(), this.context.getResponse());
                this.postProcess(wrapperContext, tinyFilters);
            }
            catch (Throwable throwable) {
                this.postProcess(wrapperContext, tinyFilters);
                throw throwable;
            }
        }
    }

    private String getServletPath(HttpServletRequest request, WebContext webContext) {
        String servletPath = (String)request.getAttribute("$_default_page");
        if (StringUtil.isBlank((String)servletPath)) {
            servletPath = request.getServletPath();
            if (StringUtil.isBlank((String)servletPath)) {
                servletPath = request.getPathInfo();
            }
            if (StringUtil.isBlank((String)servletPath)) {
                servletPath = "/";
            }
        }
        if (StringUtil.contains((String)servletPath, (String)SEARCH_STR)) {
            this.parserRequestPath(servletPath, request, webContext);
        }
        return StringUtil.substringBefore((String)servletPath, (String)SEARCH_STR);
    }

    private void parserRequestPath(String servletPath, HttpServletRequest request, final WebContext webContext) {
        ParserWebContext requestContext = (ParserWebContext)WebContextUtil.findWebContext((HttpServletRequest)request, ParserWebContext.class);
        String charset = requestContext.isUseBodyEncodingForURI() ? request.getCharacterEncoding() : requestContext.getURIEncoding();
        QueryStringParser parser = new QueryStringParser(charset, "ISO-8859-1"){

            protected void add(String key, String value) {
                webContext.put(key, (Object)value);
            }
        };
        parser.parse(StringUtil.substringAfter((String)servletPath, (String)SEARCH_STR));
    }

    private boolean isRequestPassedThru(String servletPath) {
        if (!CollectionUtil.isEmpty(this.passthruPatterns)) {
            for (Pattern pattern : this.passthruPatterns) {
                if (!pattern.matcher(servletPath).matches()) continue;
                logger.logMessage(LogLevel.DEBUG, "Passed through request: {0}", new Object[]{servletPath});
                return true;
            }
        }
        return false;
    }

    private void giveUpControl(WebContext wrapperContext) throws IOException, ServletException {
        logger.logMessage(LogLevel.DEBUG, "\u653e\u5f03\u63a7\u5236\uff0c\u5c06\u63a7\u5236\u6743\u8fd4\u56de\u7ed9servlet engine,\u8bf7\u6c42\u8def\u5f84\uff1a<{}>", new Object[]{this.servletPath});
        BufferedWebContext brc = (BufferedWebContext)WebContextUtil.findWebContext((WebContext)wrapperContext, BufferedWebContext.class);
        if (brc != null) {
            try {
                brc.setBuffering(false);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            wrapperContext.getResponse().setContentType(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.filterChain.doFilter((ServletRequest)wrapperContext.getRequest(), (ServletResponse)wrapperContext.getResponse());
    }

    private WebContext getWebContext(WebContext context, List<TinyFilter> tinyFilters, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebContext webContext = WebContextUtil.getWebContext((HttpServletRequest)context.getRequest());
        if (webContext == null) {
            webContext = this.createWrapperContext(context, tinyFilters, request, response);
            context.getRequest().setAttribute(WEB_CONTEXT_OWNER_KEY, (Object)this);
        }
        return webContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebContext createWrapperContext(WebContext context, List<TinyFilter> tinyFilters, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SimpleWebContext innerWebContext;
        SimpleWebContext wrapperedContext = innerWebContext = new SimpleWebContext(context, (FilterHandler)this, request, response);
        WebContextUtil.setWebContext((WebContext)wrapperedContext);
        logger.logMessage(LogLevel.DEBUG, "tiny-filter\u5f00\u59cb\u8fdb\u884c\u524d\u7f6e\u5904\u7406\u64cd\u4f5c");
        try {
            for (TinyFilter filter : tinyFilters) {
                wrapperedContext = filter.wrapContext((WebContext)wrapperedContext);
                logger.logMessage(LogLevel.DEBUG, "tiny-filter<{}>\u8fdb\u884c\u524d\u7f6e\u5904\u7406", new Object[]{filter.getClass().getName()});
                filter.preProcess((WebContext)wrapperedContext);
                WebContextUtil.setWebContext((WebContext)wrapperedContext);
            }
        }
        finally {
            wrapperedContext = WebContextUtil.getWebContext((HttpServletRequest)request);
            innerWebContext.setTopWebContext((WebContext)wrapperedContext);
        }
        logger.logMessage(LogLevel.DEBUG, "tiny-filter\u524d\u7f6e\u5904\u7406\u64cd\u4f5c\u7ed3\u675f");
        logger.logMessage(LogLevel.DEBUG, "Created a new web context: {}", (Context)wrapperedContext);
        return wrapperedContext;
    }

    private void handleException(WebContext webContext, Throwable e, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (webContext != null) {
            request = webContext.getRequest();
            response = webContext.getResponse();
        }
        try {
            response.setStatus(500);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearBuffer(response);
        WebExceptionHandlerManager exceptionHandlerManager = (WebExceptionHandlerManager)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("webExceptionHandlerManager");
        exceptionHandlerManager.handler(e, webContext);
    }

    private void clearBuffer(HttpServletResponse response) {
        if (!response.isCommitted()) {
            response.resetBuffer();
        }
    }

    private boolean isRequestFinished(int filterSize, WebContext webContext) {
        WebContext wrapContext = webContext;
        for (int i = 0; i < filterSize; ++i) {
            if (wrapContext == null) continue;
            if (wrapContext.isRequestFinished()) {
                return true;
            }
            wrapContext = wrapContext.getWrappedWebContext();
        }
        return false;
    }

    private void postProcess(WebContext webContext, List<TinyFilter> tinyFilters) {
        if (webContext == null) {
            return;
        }
        try {
            if (this == webContext.getRequest().getAttribute(WEB_CONTEXT_OWNER_KEY)) {
                webContext.getRequest().removeAttribute(WEB_CONTEXT_OWNER_KEY);
                this.commitWebRequest(webContext, tinyFilters);
            }
        }
        catch (Exception e) {
            logger.errorMessage("Exception occurred while commit rundata", (Throwable)e, new Object[0]);
        }
        this.setContext(webContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitWebRequest(WebContext webContext, List<TinyFilter> tinyFilters) throws ServletException, IOException {
        CommitMonitor monitor;
        logger.logMessage(LogLevel.DEBUG, "tiny-filter\u5f00\u59cb\u8fdb\u884c\u540e\u7f6e\u5904\u7406\u64cd\u4f5c");
        CommitMonitor commitMonitor = monitor = this.getCommitMonitor(webContext);
        synchronized (commitMonitor) {
            if (!monitor.isCommitted()) {
                boolean doCommitHeaders = !monitor.isHeadersCommitted();
                monitor.setCommitted(true);
                HttpServletRequest request = webContext.getRequest();
                int size = tinyFilters.size() - 1;
                WebContext wrapperedContext = webContext;
                for (int i = size; i >= 0; --i) {
                    TinyFilter filter = tinyFilters.get(i);
                    if (filter != null) {
                        logger.logMessage(LogLevel.DEBUG, "tiny-filter<{}>\u8fdb\u884c\u540e\u7f6e\u5904\u7406", new Object[]{filter.getClass().getName()});
                        if (wrapperedContext instanceof TwoPhaseCommitWebContext && doCommitHeaders) {
                            ((TwoPhaseCommitWebContext)wrapperedContext).commitHeaders();
                        }
                        filter.postProcess(wrapperedContext);
                    }
                    wrapperedContext = wrapperedContext.getWrappedWebContext();
                }
                WebContextUtil.removeWebContext((HttpServletRequest)request);
                logger.logMessage(LogLevel.DEBUG, "Committed request: {}", new Object[]{request});
            }
        }
        logger.logMessage(LogLevel.DEBUG, "tiny-filter\u540e\u7f6e\u5904\u7406\u64cd\u4f5c\u7ed3\u675f");
    }

    public String getServletPath() {
        return this.servletPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitHeaders(WebContext wrapperedContext) {
        CommitMonitor monitor;
        CommitMonitor commitMonitor = monitor = this.getCommitMonitor(wrapperedContext);
        synchronized (commitMonitor) {
            if (!monitor.isHeadersCommitted()) {
                monitor.setHeadersCommitted(true);
                for (WebContext rc = wrapperedContext; rc != null; rc = rc.getWrappedWebContext()) {
                    if (!(rc instanceof TwoPhaseCommitWebContext)) continue;
                    TwoPhaseCommitWebContext tpc = (TwoPhaseCommitWebContext)rc;
                    logger.logMessage(LogLevel.TRACE, "Committing headers: {}", new Object[]{tpc.getClass().getSimpleName()});
                    tpc.commitHeaders();
                }
            }
        }
    }

    private CommitMonitor getCommitMonitor(WebContext webContext) {
        CommitMonitor monitor = (CommitMonitor)WebContextUtil.findWebContext((WebContext)webContext, SimpleWebContext.class);
        return (CommitMonitor)Assert.assertNotNull((Object)monitor, (String)"no monitor", (Object[])new Object[0]);
    }
}

