/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.FilterHandler;
import org.tinygroup.weblayer.FilterWrapper;
import org.tinygroup.weblayer.InputStreamRepeatRead;
import org.tinygroup.weblayer.TinyFilterHandler;
import org.tinygroup.weblayer.TinyFilterManager;
import org.tinygroup.weblayer.TinyProcessorManager;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManager;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManagerHolder;
import org.tinygroup.weblayer.impl.WebContextImpl;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.weblayer.webcontext.util.WebContextUtil;
import org.tinygroup.xmlparser.node.XmlNode;

public class TinyHttpFilter
implements Filter {
    public static final String DEFAULT_POST_DATA_KEY = "$_post_data_key";
    public static final String DEFAULT_POST_NODE_NAME = "$_post_node_name";
    public static final String DEFAULT_PAGE_KEY = "$_default_page";
    public static final String REQUEST_REMOTE_HOST_MDC_KEY = "req.remoteHost";
    public static final String REQUEST_USER_AGENT_MDC_KEY = "req.userAgent";
    public static final String REQUEST_REQUEST_URI = "req.requestURI";
    public static final String REQUEST_QUERY_STRING = "req.queryString";
    public static final String REQUEST_REQUEST_URL = "req.requestURL";
    public static final String REQUEST_X_FORWARDED_FOR = "req.xForwardedFor";
    public static final String REQUEST_ID = "req.id";
    public static final String REQUEST_REMOTE_ADDR = "req.remoteAddr";
    private static final String REQUEST_URI_WITH_QUERY_STRING = "req.requestURIWithQueryString";
    private static final String EXCLUDE_PATH = "excludePath";
    private static final String CAN_REPEAT_READ = "canRepeatRead";
    private static final String PASSTHRU_PATH = "passthruPath";
    private static final Logger logger = LoggerFactory.getLogger(TinyHttpFilter.class);
    private static final String POST_DATA_PROCESS = "post-data-process";
    private static final String DATA_MAPPING = "data-mapping";
    private static final String HOST_PATTERN = "host-pattern";
    private static final String URL_PATTERN = "url-pattern";
    private static final String POST_DATA_KEY = "post-data-key";
    private static String[] defaultFiles = new String[]{"index.page", "index.htm", "index.html", "index.jsp"};
    private TinyProcessorManager tinyProcessorManager;
    private TinyFilterManager tinyFilterManager;
    private List<Pattern> excludePatterns = new ArrayList<Pattern>();
    private List<Pattern> passthruPatterns = new ArrayList<Pattern>();
    private boolean repeatRead = true;
    private Map<String, String> hostPatternMapping = new HashMap<String, String>();
    private Map<String, String> postDataUrlPattern = new HashMap<String, String>();
    private String postDataKey;
    private FilterWrapper wrapper;
    private FullContextFileRepository fullContextFileRepository;

    public void destroy() {
        this.destroyTinyProcessors();
        this.destroyTinyFilters();
    }

    private void destroyTinyFilters() {
        this.tinyFilterManager.destoryTinyResources();
    }

    private void destroyTinyProcessors() {
        this.tinyProcessorManager.destoryTinyResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            InputStreamRepeatRead inputStreamRepeatRead = new InputStreamRepeatRead(this.repeatRead);
            request = inputStreamRepeatRead.requestWrapper(request);
            this.requestInitListener((ServletRequest)request);
            this.putMDC(request, response);
            String servletPath = WebContextUtil.getServletPath((HttpServletRequest)request);
            if (this.isExcluded(servletPath)) {
                logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84:<{}>,\u88ab\u62d2\u7edd", new Object[]{servletPath});
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            WebContextImpl context = new WebContextImpl();
            context.put("springUtil", (Object)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()));
            this.postDataProcess(servletPath, request, (WebContext)context);
            context.putSubContext("applicationproperties", (Context)new ContextImpl(ConfigurationUtil.getConfigurationManager().getConfiguration()));
            this.putRequestInfo(request, (WebContext)context);
            context.init(request, response, ServletContextHolder.getServletContext());
            if (servletPath.endsWith("/")) {
                for (String defaultFile : defaultFiles) {
                    String tmpPath = servletPath + defaultFile;
                    FileObject fileObject = this.fullContextFileRepository.getFileObject(tmpPath);
                    if (fileObject == null || !fileObject.isExist()) continue;
                    servletPath = tmpPath;
                    request.setAttribute(DEFAULT_PAGE_KEY, (Object)servletPath);
                    break;
                }
            }
            TinyFilterHandler handler = new TinyFilterHandler(servletPath, filterChain, (WebContext)context, this.tinyFilterManager, this.tinyProcessorManager, this.passthruPatterns);
            if (this.wrapper != null) {
                this.wrapper.filterWrapper((WebContext)context, (FilterHandler)handler);
            } else {
                handler.tinyFilterProcessor(request, response);
            }
        }
        finally {
            this.requestDestroyListener(servletRequest);
            this.clearMDC(request, response);
        }
    }

    private void clearMDC(HttpServletRequest request, HttpServletResponse response) {
        LoggerFactory.removeThreadVariable((String)REQUEST_REQUEST_URI);
        LoggerFactory.removeThreadVariable((String)REQUEST_REQUEST_URL);
        LoggerFactory.removeThreadVariable((String)REQUEST_QUERY_STRING);
        LoggerFactory.removeThreadVariable((String)REQUEST_REMOTE_ADDR);
        LoggerFactory.removeThreadVariable((String)REQUEST_ID);
        LoggerFactory.removeThreadVariable((String)REQUEST_URI_WITH_QUERY_STRING);
        LoggerFactory.removeThreadVariable((String)REQUEST_REMOTE_HOST_MDC_KEY);
        LoggerFactory.removeThreadVariable((String)REQUEST_USER_AGENT_MDC_KEY);
        LoggerFactory.removeThreadVariable((String)REQUEST_X_FORWARDED_FOR);
    }

    private void putMDC(HttpServletRequest request, HttpServletResponse response) {
        LoggerFactory.putThreadVariable((String)REQUEST_REQUEST_URI, (String)request.getRequestURI());
        StringBuffer requestURL = request.getRequestURL();
        if (requestURL != null) {
            LoggerFactory.putThreadVariable((String)REQUEST_REQUEST_URL, (String)requestURL.toString());
        }
        LoggerFactory.putThreadVariable((String)REQUEST_QUERY_STRING, (String)StringUtils.defaultString((String)request.getQueryString()));
        LoggerFactory.putThreadVariable((String)REQUEST_URI_WITH_QUERY_STRING, (String)(request.getRequestURI() + (request.getQueryString() == null ? "" : "?" + request.getQueryString())));
        LoggerFactory.putThreadVariable((String)REQUEST_REMOTE_ADDR, (String)StringUtils.defaultString((String)request.getRemoteAddr()));
        LoggerFactory.putThreadVariable((String)REQUEST_ID, (String)StringUtils.remove((String)UUID.randomUUID().toString(), (String)"-"));
        LoggerFactory.putThreadVariable((String)REQUEST_REMOTE_HOST_MDC_KEY, (String)request.getRemoteHost());
        LoggerFactory.putThreadVariable((String)REQUEST_USER_AGENT_MDC_KEY, (String)request.getHeader("User-Agent"));
        LoggerFactory.putThreadVariable((String)REQUEST_X_FORWARDED_FOR, (String)request.getHeader("X-Forwarded-For"));
    }

    private void requestInitListener(ServletRequest servletRequest) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List listeners = configManager.getRequestListeners();
        ServletRequestEvent event = new ServletRequestEvent(ServletContextHolder.getServletContext(), servletRequest);
        for (ServletRequestListener listener : listeners) {
            logger.logMessage(LogLevel.DEBUG, "ServletRequestListener:[{0}] will be requestInitialized", new Object[]{listener});
            listener.requestInitialized(event);
            logger.logMessage(LogLevel.DEBUG, "ServletRequestListener:[{0}] requestInitialized", new Object[]{listener});
        }
    }

    private void requestDestroyListener(ServletRequest servletRequest) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List listeners = configManager.getRequestListeners();
        ServletRequestEvent event = new ServletRequestEvent(ServletContextHolder.getServletContext(), servletRequest);
        for (ServletRequestListener listener : listeners) {
            logger.logMessage(LogLevel.DEBUG, "ServletRequestListener:[{0}] will be requestDestroyed", new Object[]{listener});
            listener.requestDestroyed(event);
            logger.logMessage(LogLevel.DEBUG, "ServletRequestListener:[{0}] requestDestroyed", new Object[]{listener});
        }
    }

    private void postDataProcess(String servletPath, HttpServletRequest request, WebContext context) throws IOException {
        if (this.isPostMethod(request)) {
            String remoteHost = request.getRemoteHost();
            String remoteAddr = request.getRemoteAddr();
            for (String nodeName : this.hostPatternMapping.keySet()) {
                String hostPattern = this.hostPatternMapping.get(nodeName);
                String urlPattern = this.postDataUrlPattern.get(nodeName);
                if (!Pattern.matches(hostPattern, remoteHost) && !Pattern.matches(hostPattern, remoteAddr) || !Pattern.matches(urlPattern, servletPath)) continue;
                context.put(this.postDataKey, (Object)StreamUtil.readBytes((InputStream)request.getInputStream(), (boolean)true).toByteArray());
                break;
            }
        }
    }

    private boolean isPostMethod(HttpServletRequest request) {
        return request.getMethod().equalsIgnoreCase("post");
    }

    private void initPostDataProcess() {
        ConfigurationManager appConfigManager = ConfigurationUtil.getConfigurationManager();
        XmlNode parserNode = (XmlNode)appConfigManager.getApplicationConfiguration().getSubNode(POST_DATA_PROCESS);
        if (parserNode != null) {
            this.postDataKey = StringUtil.defaultIfBlank((String)parserNode.getAttribute(POST_DATA_KEY), (String)DEFAULT_POST_DATA_KEY);
            List dataMapNode = parserNode.getSubNodes(DATA_MAPPING);
            if (!CollectionUtil.isEmpty((Collection)dataMapNode)) {
                for (int i = 0; i < dataMapNode.size(); ++i) {
                    XmlNode xmlNode = (XmlNode)dataMapNode.get(i);
                    String hostsPattern = xmlNode.getAttribute(HOST_PATTERN);
                    String urlPattern = xmlNode.getAttribute(URL_PATTERN);
                    String nodeName = xmlNode.getAttribute("name");
                    if (StringUtil.isBlank((String)nodeName)) {
                        nodeName = DEFAULT_POST_NODE_NAME + i;
                    }
                    if (StringUtil.isBlank((String)hostsPattern)) {
                        hostsPattern = ".*";
                    }
                    if (StringUtil.isBlank((String)urlPattern)) {
                        urlPattern = ".*";
                    }
                    this.hostPatternMapping.put(nodeName, hostsPattern);
                    this.postDataUrlPattern.put(nodeName, urlPattern);
                }
            }
        }
    }

    private void putRequestInfo(HttpServletRequest request, WebContext context) {
        String path = request.getContextPath();
        if (path == null) {
            path = "";
        }
        context.put("TINY_CONTEXT_PATH", (Object)path);
        context.put("TINY_REQUEST_URI", (Object)request.getRequestURI());
        String servletPath = request.getServletPath();
        if (servletPath == null || servletPath.length() == 0) {
            servletPath = request.getPathInfo();
        }
        context.put("TINY_SERVLET_PATH", (Object)servletPath);
    }

    private boolean isExcluded(String servletPath) {
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(servletPath).matches()) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.logMessage(LogLevel.INFO, "filter\u521d\u59cb\u5316\u5f00\u59cb...");
        this.fullContextFileRepository = (FullContextFileRepository)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("fullContextFileRepository");
        String openStr = filterConfig.getInitParameter(CAN_REPEAT_READ);
        if (!StringUtil.isBlank((String)openStr)) {
            this.repeatRead = Boolean.parseBoolean(openStr);
        }
        this.initExcludePattern(filterConfig);
        this.initPassthruPattern(filterConfig);
        this.initTinyFilters();
        this.initTinyFilterWrapper();
        this.initTinyProcessors();
        this.initPostDataProcess();
        logger.logMessage(LogLevel.INFO, "filter\u521d\u59cb\u5316\u7ed3\u675f...");
    }

    private void initTinyFilterWrapper() {
        this.wrapper = this.tinyFilterManager.getFilterWrapper();
    }

    private void initExcludePattern(FilterConfig filterConfig) {
        this.excludePatterns.clear();
        String excludePath = filterConfig.getInitParameter(EXCLUDE_PATH);
        if (excludePath != null) {
            String[] excludeArray;
            for (String path : excludeArray = excludePath.split(",")) {
                this.excludePatterns.add(Pattern.compile(path));
            }
        }
    }

    private void initPassthruPattern(FilterConfig filterConfig) {
        this.passthruPatterns.clear();
        String passthruPath = filterConfig.getInitParameter(PASSTHRU_PATH);
        if (passthruPath != null) {
            String[] excludeArray;
            for (String path : excludeArray = passthruPath.split(",")) {
                this.passthruPatterns.add(Pattern.compile(path));
            }
        }
    }

    private void initTinyFilters() throws ServletException {
        this.tinyFilterManager = (TinyFilterManager)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("tinyFilterManager");
        this.tinyFilterManager.initTinyResources();
    }

    private void initTinyProcessors() throws ServletException {
        this.tinyProcessorManager = (TinyProcessorManager)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("tinyProcessorManager");
        this.tinyProcessorManager.initTinyResources();
    }
}

