/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.threadpool;

/**
 * 任务处理线程
 * 
 * @author luoguo
 * 
 */
public class TaskThread extends Thread {
	private Runnable task = null;
	private boolean stop = false;
	private ThreadPool threadPool;

	public ThreadPool getThreadPool() {
		return threadPool;
	}

	public void setThreadPool(ThreadPool threadPool) {
		this.threadPool = threadPool;
	}

	/**
	 * 构造函数
	 * 
	 * @param threadPool
	 * @param pool
	 * @param group
	 * @param name
	 */
	public TaskThread(ThreadGroup group) {
		super(group, "");
	}

	/**
	 * 制定要执行的任务
	 * @param task
	 * @return void 
	 */
	public void executeTask(Runnable task) {
		this.task = task;
	}

	public boolean isStop() {
		return stop;
	}

	public void setStop(boolean stop) {
		this.stop = stop;
	}

	public synchronized void run() {
		while (!stop) {
			if (task != null) {// 如果有任务就完成任务
				task.run();//调用task线程

				if (threadPool != null) {
					threadPool.getTaskThreadPool().returnObject(this);//执行完任务，返还执行线程
				}
				task = null;
			} else {
				try {
					wait();// 等待任务
				} catch (InterruptedException e) {
					// 如果被通知结束，则结束
					stop = true;
					break;
				}
			}
		}
		if (threadPool != null) {
			threadPool.getTaskThreadPool().returnObject(this);
		}
	}
}
