/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.threadpool;

import org.tinygroup.pool.ObjectProvider;
import org.tinygroup.threadpool.impl.ThreadPoolImpl;

public class ThreadProvider implements ObjectProvider<TaskThread> {
	private ThreadGroup group;
	private ThreadPoolImpl threadPool;

	public ThreadProvider() {
	}

	/**
	 * 构造方法
	 * @param threadPool
	 * @param group
	 */
	public ThreadProvider(ThreadPoolImpl threadPool, ThreadGroup group) {
		this.group = group;
		this.threadPool = threadPool;
	}

	/**
	 * 创建任务线程
	 * @return TaskThread
	 */
	public TaskThread createObject() {
		TaskThread t = new TaskThread(group);
		t.setThreadPool(threadPool);
		t.setName(t.getId() + "");
		t.start();
		return t;
	}

	public int getIdleActionInterval() {
		return 0;
	}

	public void idleAction(TaskThread thread) {

	}

	/**
	 * 释放任务线程
	 * @param thread
	 * @return void 
	 */
	public void releaseObject(TaskThread thread) {
		synchronized (thread) {
			thread.setStop(true);
			thread.notify();
		}
	}

	public boolean test(TaskThread thread) {
		return !thread.isStop();
	}

}
