/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.threadpool.impl;

import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.pool.ObjectProvider;
import org.tinygroup.pool.impl.PoolDoubleList;
import org.tinygroup.queue.PriorityQueue;
import org.tinygroup.queue.impl.PriorityQueueImpl;
import org.tinygroup.threadpool.TaskThread;
import org.tinygroup.threadpool.ThreadPool;
import org.tinygroup.threadpool.ThreadProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolImpl
implements ThreadPool {
    private static Logger logger = LoggerFactory.getLogger(ThreadPoolImpl.class);
    private MainThread mainThread;
    private PoolDoubleList<TaskThread> threadPool = new PoolDoubleList();
    private int initSize = 10;
    private int maxSize = 20;
    private int increaseStep = 3;
    private boolean testBeforeBorrow;
    private PriorityQueue<Runnable> priorityQueue = new PriorityQueueImpl();
    private ThreadGroup group = null;

    @Override
    public PoolDoubleList<TaskThread> getTaskThreadPool() {
        return this.threadPool;
    }

    public int getInitSize() {
        return this.initSize;
    }

    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getIncreaseStep() {
        return this.increaseStep;
    }

    public void setIncreaseStep(int increaseStep) {
        this.increaseStep = increaseStep;
    }

    public PriorityQueue<Runnable> getPriorityQueue() {
        return this.priorityQueue;
    }

    public ThreadPoolImpl(String name) {
        this.group = new ThreadGroup(name);
        this.mainThread = new MainThread(this.group);
        this.mainThread.setName("" + this.mainThread.getId());
        this.priorityQueue.setPriorityIncreaseStrategy(null);
    }

    @Override
    public void stopThreadPool() {
        this.mainThread.setStopThreadPool(true);
    }

    @Override
    public void startThreadPool() {
        this.threadPool.initPool(this.initSize, this.maxSize, this.increaseStep, this.testBeforeBorrow, (ObjectProvider)new ThreadProvider(this, this.group));
        this.threadPool.start();
        this.mainThread.start();
    }

    public void interrupt() {
    }

    @Override
    public boolean addTask(Runnable task) {
        if (this.mainThread.isStopThreadPool()) {
            return false;
        }
        return this.priorityQueue.offer((Object)task);
    }

    @Override
    public int size() {
        return this.priorityQueue.getSize();
    }

    public class MainThread
    extends Thread {
        private boolean stopThreadPool;

        public MainThread(ThreadGroup group) {
            super(group, (Runnable)null);
            this.stopThreadPool = false;
        }

        public boolean isStopThreadPool() {
            return this.stopThreadPool;
        }

        public void setStopThreadPool(boolean stopThreadPool) {
            this.stopThreadPool = stopThreadPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopThreadPool) {
                while (ThreadPoolImpl.this.threadPool.getUsingSize() < ThreadPoolImpl.this.getMaxSize() && !ThreadPoolImpl.this.priorityQueue.isEmpty()) {
                    try {
                        TaskThread t = (TaskThread)ThreadPoolImpl.this.threadPool.borrowObject();
                        Runnable r = (Runnable)ThreadPoolImpl.this.priorityQueue.poll();
                        TaskThread taskThread = t;
                        synchronized (taskThread) {
                            t.executeTask(r);
                            t.notify();
                        }
                    }
                    catch (Exception e) {
                        logger.errorMessage(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    MainThread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.stopThreadPool = true;
                }
            }
            ThreadPoolImpl.this.threadPool.stop();
        }
    }
}

