/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.threadpool;

import org.tinygroup.pool.ObjectProvider;
import org.tinygroup.threadpool.TaskThread;
import org.tinygroup.threadpool.impl.ThreadPoolImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadProvider
implements ObjectProvider<TaskThread> {
    private ThreadGroup group;
    private ThreadPoolImpl threadPool;

    public ThreadProvider() {
    }

    public ThreadProvider(ThreadPoolImpl threadPool, ThreadGroup group) {
        this.group = group;
        this.threadPool = threadPool;
    }

    public TaskThread createObject() {
        TaskThread t = new TaskThread(this.group);
        t.setThreadPool(this.threadPool);
        t.setName(t.getId() + "");
        t.start();
        return t;
    }

    public int getIdleActionInterval() {
        return 0;
    }

    public void idleAction(TaskThread thread) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseObject(TaskThread thread) {
        TaskThread taskThread = thread;
        synchronized (taskThread) {
            thread.setStop(true);
            thread.notify();
        }
    }

    public boolean test(TaskThread thread) {
        return !thread.isStop();
    }
}

