/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyspider.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tinygroup.htmlparser.HtmlDocument;
import org.tinygroup.htmlparser.node.HtmlNode;
import org.tinygroup.htmlparser.parser.HtmlStringParser;
import org.tinygroup.parser.NodeFilter;
import org.tinygroup.tinyspider.Processor;
import org.tinygroup.tinyspider.SiteVisitor;
import org.tinygroup.tinyspider.Spinder;
import org.tinygroup.tinyspider.UrlRepository;
import org.tinygroup.tinyspider.Watcher;
import org.tinygroup.tinyspider.impl.SiteVisitorInclude;
import org.tinygroup.tinyspider.impl.UrlRepositoryMemory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinderImpl
implements Spinder {
    List<Watcher> watcherList = new ArrayList<Watcher>();
    List<SiteVisitor> siteVisitorList = new ArrayList<SiteVisitor>();
    private UrlRepository urlRepository;

    @Override
    public void addWatcher(Watcher watcher) {
        this.watcherList.add(watcher);
    }

    @Override
    public void processUrl(String url) {
        this.processUrl(url, null);
    }

    @Override
    public void addSiteVisitor(SiteVisitor siteVisitor) {
        this.siteVisitorList.add(siteVisitor);
    }

    @Override
    public void setUrlRepository(UrlRepository urlRepository) {
        this.urlRepository = urlRepository;
    }

    @Override
    public void processUrl(String url, Map<String, Object> parameter) {
        if (this.urlRepository == null) {
            this.urlRepository = new UrlRepositoryMemory();
        }
        if (this.urlRepository.isExist(url)) {
            throw new RuntimeException(url + "\u5df2\u7ecf\u5904\u7406\u8fc7");
        }
        String content = null;
        if (this.siteVisitorList.size() == 0) {
            this.siteVisitorList.add(new SiteVisitorInclude(".*"));
        }
        for (SiteVisitor siteVisitor : this.siteVisitorList) {
            if (!siteVisitor.isMatch(url)) continue;
            content = siteVisitor.getContent(url, parameter);
            break;
        }
        if (content == null) {
            throw new RuntimeException("\u8bfb\u53d6" + url + "\u5185\u5bb9\u5931\u8d25\u3002");
        }
        HtmlDocument document = new HtmlStringParser().parse(content);
        for (Watcher watcher : this.watcherList) {
            NodeFilter<HtmlNode> nodeFilter = watcher.getNodeFilter();
            nodeFilter.init(document.getRoot());
            List nodeList = nodeFilter.findNodeList();
            for (HtmlNode htmlNode : nodeList) {
                for (Processor e : watcher.getProcessorList()) {
                    e.process(htmlNode);
                }
            }
        }
    }
}

