/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyspider.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinygroup.tinyspider.UrlRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlRepositoryMemory
implements UrlRepository {
    Map<String, String> contentCache = new ConcurrentHashMap<String, String>();

    @Override
    public boolean isExist(String url) {
        return this.contentCache.containsKey(url);
    }

    @Override
    public boolean isExist(String url, Map<String, Object> parameter) {
        String fullUrl = this.getFullUrl(url, parameter);
        return this.isExist(fullUrl);
    }

    private String getFullUrl(String url, Map<String, Object> parameter) {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.addAll(parameter.keySet());
        Collections.sort(keyList);
        StringBuffer sb = new StringBuffer(url);
        sb.append('\u0000');
        for (String key : keyList) {
            sb.append('&');
            sb.append(key);
            sb.append('=');
            sb.append(parameter.get(key));
        }
        return sb.toString();
    }

    @Override
    public void putUrlWithContent(String url, String content) {
        this.contentCache.put(url, content);
    }

    @Override
    public void putUrlWithContent(String url, Map<String, Object> parameter, String content) {
        this.contentCache.put(this.getFullUrl(url, parameter), content);
    }

    @Override
    public String getContent(String url) {
        return this.contentCache.get(url);
    }

    @Override
    public String getContent(String url, Map<String, Object> parameter) {
        return this.getContent(this.getFullUrl(url, parameter));
    }
}

