/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.weblayer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.tinygroup.application.Application;
import org.tinygroup.application.impl.ApplicationDefault;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.impl.FileResolverImpl;
import org.tinygroup.fileresolver.impl.SpringBeansFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.weblayer.listener.TinyServletContext;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class ApplicationStartupListener implements ServletContextListener {
	private static Logger logger = LoggerFactory
			.getLogger(ApplicationStartupListener.class);
	private Application application = null;

	public void contextDestroyed(ServletContextEvent servletContextEvent) {
		logger.logMessage(LogLevel.INFO, "WEB 应用停止中...");
		application.stop();
		SpringUtil.destory();// 关闭spring容器
		logger.logMessage(LogLevel.INFO, "WEB 应用停止完成。");
	}

	@SuppressWarnings("unchecked")
	public void contextInitialized(ServletContextEvent servletContextEvent) {
		TinyServletContext servletContext=new TinyServletContext(servletContextEvent
				.getServletContext());
		ServletContextHolder.setServletContext(servletContext);
		Enumeration<String> enumeration = servletContextEvent
				.getServletContext().getAttributeNames();
		logger.logMessage(LogLevel.INFO, "WEB环境属性开始");
		while (enumeration.hasMoreElements()) {
			String key = enumeration.nextElement();
			logger.logMessage(LogLevel.INFO, "{0}=[{1}]", key,
					servletContextEvent.getServletContext().getAttribute(key));
		}
		logger.logMessage(LogLevel.INFO, "WEB 应用启动中...");
		
		logger.logMessage(LogLevel.INFO, "WEB 应用信息：[{0}]", servletContextEvent
				.getServletContext().getServerInfo());
		String webRootPath = servletContextEvent.getServletContext()
				.getRealPath("/");
		if (webRootPath == null) {
			try {
				webRootPath = servletContextEvent.getServletContext()
						.getResource("/").getFile();
			} catch (MalformedURLException e) {
				logger.errorMessage("获取WEBROOT失败！", e);
			}
		}
		logger.logMessage(LogLevel.INFO, "TINY_WEBROOT：[{0}]", webRootPath);
		ConfigurationUtil.getConfigurationManager().setApplicationProperty(
				"TINY_WEBROOT", webRootPath);
		logger.logMessage(LogLevel.INFO, "应用参数<TINY_WEBROOT>=<{}>", webRootPath);

		logger.logMessage(LogLevel.INFO, "ServerContextName：[{0}]",
				servletContextEvent.getServletContext().getServletContextName());
		logger.logMessage(LogLevel.INFO, "WEB环境属性结束");

		InputStream inputStream = this.getClass().getResourceAsStream(
				"/application.xml");
		if (inputStream == null) {
			try {
				File file = new File(webRootPath + "/classes/application.xml");
				inputStream = new FileInputStream(file);
			} catch (FileNotFoundException e) {
				logger.errorMessage("获取配置文件失败，错误原因：！", e, e.getMessage());
			}
		}
		loadSpringBeans();
		application = new ApplicationDefault(inputStream,true);
		application.start();

		logger.logMessage(LogLevel.INFO, "WEB 应用启动完成。");
	}

	private void loadSpringBeans() {
		logger.logMessage(LogLevel.INFO, "加载Spring Bean文件开始...");
		FileResolver fileResolver = new FileResolverImpl();
		InputStream inputStream = this.getClass().getResourceAsStream("/application.xml");
		loadFileResolverConfig(fileResolver,inputStream);
		fileResolver.addFileProcessor(new SpringBeansFileProcessor());
		fileResolver.resolve();
		logger.logMessage(LogLevel.INFO, "加载Spring Bean文件结束。");
	}

	private void loadFileResolverConfig(FileResolver fileResolver,InputStream inputStream) {
		String applicationConfig = "";
		if (inputStream != null) {
			try {
				applicationConfig = StreamUtil.readText(inputStream, "UTF-8",
						false);
			} catch (Exception e) {
				logger.errorMessage("载入应用配置信息时出错，错误原因：{}！", e, e.getMessage());
			}
		}
		
		XmlStringParser parser = new XmlStringParser();
		XmlNode root = parser.parse(applicationConfig).getRoot();
		PathFilter<XmlNode> filter = new PathFilter<XmlNode>(root);
		String resolve = filter.findNode(
				"/application/file-resolver-configuration").getAttribute(
				"resolve-classpath");
		if (resolve == null || resolve.length() == 0) {
			resolve = "true";
		}

//		fileResolver.setClassPathResolve(Boolean.parseBoolean(resolve));
		List<XmlNode> skipList = filter
				.findNodeList("/application/file-resolver-configuration/skip-patterns/skip-pattern");
		for (XmlNode node : skipList) {
			fileResolver.addSkipPathPattern(node.getAttribute("pattern"));
		}
		List<XmlNode> classPathList = filter
				.findNodeList("/application/file-resolver-configuration/class-paths/class-path");
		for (XmlNode classPath : classPathList) {
			fileResolver.addManualClassPath(classPath
					.getAttribute("path"));
		}
		for (XmlNode node : skipList) {
			fileResolver.addSkipPathPattern(node.getAttribute("pattern"));
		}
	}

	

	
}
