/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.weblayer.fileresolver;

import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.servicemapping.ServiceMappingManager;
import org.tinygroup.weblayer.servicemapping.config.ServiceViewMappings;
import org.tinygroup.xstream.XStreamFactory;

import com.thoughtworks.xstream.XStream;

public class ServiceMappingFileProcessor extends AbstractFileProcessor{

	private static final String SERVICEMAPPING_EXT_FILENAMES = ".servicemapping.xml";
	
	public boolean isMatch(FileObject fileObject) {
		return fileObject.getFileName().endsWith(SERVICEMAPPING_EXT_FILENAMES);
	}

	public void process() {
		ServiceMappingManager manager = SpringUtil.getBean(ServiceMappingManager.MANAGER_BEAN);
		XStream stream = XStreamFactory
				.getXStream(ServiceMappingManager.XSTREAM_PACKAGENAME);
		for (FileObject fileObject : fileObjects) {
			logger.logMessage(LogLevel.INFO, "正在ServiceMappings文件[{0}]",
					fileObject.getAbsolutePath());
			try {
				ServiceViewMappings mappings = (ServiceViewMappings) stream
						.fromXML(fileObject.getInputStream());
				manager.addServiceMappings(mappings);
			} catch (Exception e) {
				logger.errorMessage("读取ServiceMappings文件[{0}]出错", e,fileObject.getAbsolutePath());
			}

			logger.logMessage(LogLevel.INFO, "读取ServiceMappings文件[{0}]结束",
					fileObject.getAbsolutePath());
		}
	}

}
