/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.weblayer.servicemapping.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.tinygroup.annotation.AnnotationMethodAction;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.service.annotation.ServiceMethod;
import org.tinygroup.weblayer.servicemapping.ServiceMappingManager;
import org.tinygroup.weblayer.servicemapping.config.ServiceViewMappings;

/**
 * 
 * 功能说明:在类注解上发现控制层@Controller,并在方法上发现@RequestMapping时，进行的逻辑处理类
 * <p>
 * 系统版本: v1.0<br>
 * 开发人员: renhui <br>
 * 开发时间: 2013-4-22 <br>
 * 功能描述: 写明作用，调用方式，使用场景，以及特殊情况<br>
 */
public class ServiceViewMappingClassAction implements AnnotationMethodAction {

	private ServiceMappingManager serviceMappingManager;
	Logger logger = LoggerFactory
			.getLogger(ServiceViewMappingClassAction.class);

	public ServiceMappingManager getServiceMappingManager() {
		return serviceMappingManager;
	}

	public void setServiceMappingManager(
			ServiceMappingManager serviceMappingManager) {
		this.serviceMappingManager = serviceMappingManager;
	}

	public <T> void process(Class<T> clazz, Method method, Annotation annotation) {
		ServiceMethod serviceMethod = method.getAnnotation(ServiceMethod.class);
		if (serviceMethod != null) {
			ServiceViewMapping serviceViewMapping = method
					.getAnnotation(ServiceViewMapping.class);
			ServiceViewMappings mappings = new ServiceViewMappings();
			List<org.tinygroup.weblayer.servicemapping.config.ServiceViewMapping> serviceViewMappings = new ArrayList<org.tinygroup.weblayer.servicemapping.config.ServiceViewMapping>();
			mappings.setServiceViewMappings(serviceViewMappings);
			org.tinygroup.weblayer.servicemapping.config.ServiceViewMapping mapping = new org.tinygroup.weblayer.servicemapping.config.ServiceViewMapping();
			serviceViewMappings.add(mapping);
			mapping.setServiceId(serviceMethod.serviceId());
			mapping.setPath(serviceViewMapping.value());
			serviceMappingManager.addServiceMappings(mappings);
		} else {
			logger.logMessage(LogLevel.ERROR,
					"类[{}]的方法[{}]声明了ServiceViewMapping注解，但是没有声明Service注解！",
					clazz.getName(), method.getName());
		}
	}
}
