/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.weblayer.TinyFilter;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.DefaultWebContext;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTinyFilter
implements TinyFilter {
    protected static final String TINY_FILTER = "tiny-filter";
    protected static final String INIT_PARAM = "init-param";
    protected static final String FILTER_MAPPING = "filter-mapping";
    private XmlNode xmlNode;
    protected Map<String, String> initParamMap = new HashMap<String, String>();
    private List<Pattern> patterns = new ArrayList<Pattern>();
    private List<String> patternStrs = new ArrayList<String>();
    protected static Logger logger = LoggerFactory.getLogger(AbstractTinyFilter.class);

    public String getNodeName() {
        return TINY_FILTER;
    }

    @Override
    public void setConfiguration(XmlNode xmlNode) {
        this.xmlNode = xmlNode;
    }

    protected void initPattern(XmlNode xmlNode) {
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List filterMappings = nameFilter.findNodeList(FILTER_MAPPING);
        for (XmlNode filterMapping : filterMappings) {
            String urlPattern = filterMapping.getAttribute("url-pattern");
            if (!this.patternStrs.contains(urlPattern)) {
                this.patterns.add(Pattern.compile(urlPattern));
                this.patternStrs.add(urlPattern);
            }
            logger.logMessage(LogLevel.DEBUG, "<{}>\u7684url-pattern:'{}'", new Object[]{this.getClass().getName(), urlPattern});
        }
    }

    protected void initParam(XmlNode xmlNode) {
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List initParamNodes = nameFilter.findNodeList(INIT_PARAM);
        for (XmlNode initParamNode : initParamNodes) {
            String name = initParamNode.getAttribute("name");
            String value = initParamNode.getAttribute("value");
            this.initParamMap.put(name, value);
            logger.logMessage(LogLevel.DEBUG, "<{}>\u7684\u521d\u59cb\u5316\u53c2\u6570name='{}',value='{}'", new Object[]{this.getClass().getName(), name, value});
        }
    }

    public XmlNode getConfiguration() {
        return this.xmlNode;
    }

    @Override
    public void preProcess(WebContext context) {
    }

    @Override
    public void postProcess(WebContext context) {
    }

    @Override
    public void initTinyFilter() {
        if (this.xmlNode != null) {
            this.initParam(this.xmlNode);
            this.initPattern(this.xmlNode);
        }
    }

    @Override
    public void destoryTinyFilter() {
        this.xmlNode = null;
        this.initParamMap = null;
        this.patterns = null;
        this.patternStrs = null;
    }

    @Override
    public boolean isMatch(String url) {
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.matches()) continue;
            logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84\uff1a<{}>,\u5339\u914d\u7684tiny-filter:<{}>", new Object[]{url, this.getClass().getSimpleName()});
            return true;
        }
        return false;
    }

    public Map<String, String> getInitParamMap() {
        return this.initParamMap;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public WebContext wrapContext(WebContext wrappedContext) {
        WebContext context = this.getAlreadyWrappedContext(wrappedContext);
        this.initContext(context);
        return context;
    }

    protected void initContext(WebContext context) {
    }

    protected WebContext getAlreadyWrappedContext(WebContext wrappedContext) {
        return new DefaultWebContext(wrappedContext);
    }

    protected String get(String param) {
        return this.getInitParamMap().get(param);
    }

    protected void parserExtraConfig(XmlNode parserNode) {
    }

    public int getOrder() {
        return 0;
    }
}

