/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.weblayer.TinyProcessor;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTinyProcessor
implements TinyProcessor {
    private static final String TINY_PROCESSOR = "tiny-processor";
    private static final String INIT_PARAM = "init-param";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private XmlNode xmlNode;
    private Map<String, String> initParamMap = new HashMap<String, String>();
    private List<Pattern> patterns = new ArrayList<Pattern>();
    private List<String> patternStrs = new ArrayList<String>();
    private static Logger logger = LoggerFactory.getLogger(AbstractTinyProcessor.class);

    public String getNodeName() {
        return TINY_PROCESSOR;
    }

    @Override
    public void setConfiguration(XmlNode xmlNode) {
        this.xmlNode = xmlNode;
    }

    @Override
    public void init() {
        if (this.xmlNode != null) {
            this.initParam(this.xmlNode);
            this.initPattern(this.xmlNode);
        }
    }

    @Override
    public void destory() {
        this.xmlNode = null;
        this.initParamMap = null;
        this.patterns = null;
        this.patternStrs = null;
    }

    private void initPattern(XmlNode xmlNode) {
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List servletMappings = nameFilter.findNodeList(SERVLET_MAPPING);
        for (XmlNode servletMapping : servletMappings) {
            String urlPattern = servletMapping.getAttribute("url-pattern");
            if (!this.patternStrs.contains(urlPattern)) {
                this.patterns.add(Pattern.compile(urlPattern));
                this.patternStrs.add(urlPattern);
            }
            logger.logMessage(LogLevel.DEBUG, "<{}>\u7684url-pattern:'{}'", new Object[]{this.getClass().getName(), urlPattern});
        }
    }

    private void initParam(XmlNode xmlNode) {
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List initParamNodes = nameFilter.findNodeList(INIT_PARAM);
        for (XmlNode initParamNode : initParamNodes) {
            String name = initParamNode.getAttribute("name");
            String value = initParamNode.getAttribute("value");
            this.initParamMap.put(name, value);
            logger.logMessage(LogLevel.DEBUG, "<{}>\u7684\u521d\u59cb\u5316\u53c2\u6570name='{}',value='{}'", new Object[]{this.getClass().getName(), name, value});
        }
    }

    public XmlNode getConfiguration() {
        return this.xmlNode;
    }

    @Override
    public boolean isMatch(String urlString) {
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(urlString);
            if (!matcher.matches()) continue;
            logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84\uff1a<{}>,\u5339\u914d\u7684tiny-processor:<{}>", new Object[]{urlString, this.getClass().getSimpleName()});
            return true;
        }
        return false;
    }

    public Map<String, String> getInitParamMap() {
        return this.initParamMap;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public void process(String urlString, WebContext context) {
        this.reallyProcess(urlString, context);
    }

    public abstract void reallyProcess(String var1, WebContext var2);
}

