/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.tinygroup.application.Application;
import org.tinygroup.application.impl.ApplicationDefault;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.impl.FileResolverImpl;
import org.tinygroup.fileresolver.impl.SpringBeansFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.weblayer.listener.TinyServletContext;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class ApplicationStartupListener
implements ServletContextListener {
    private static Logger logger = LoggerFactory.getLogger(ApplicationStartupListener.class);
    private Application application = null;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u505c\u6b62\u4e2d...");
        this.application.stop();
        SpringUtil.destory();
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u505c\u6b62\u5b8c\u6210\u3002");
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        TinyServletContext servletContext = new TinyServletContext(servletContextEvent.getServletContext());
        ServletContextHolder.setServletContext(servletContext);
        Enumeration enumeration = servletContextEvent.getServletContext().getAttributeNames();
        logger.logMessage(LogLevel.INFO, "WEB\u73af\u5883\u5c5e\u6027\u5f00\u59cb");
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            logger.logMessage(LogLevel.INFO, "{0}=[{1}]", new Object[]{key, servletContextEvent.getServletContext().getAttribute(key)});
        }
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u542f\u52a8\u4e2d...");
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u4fe1\u606f\uff1a[{0}]", new Object[]{servletContextEvent.getServletContext().getServerInfo()});
        String webRootPath = servletContextEvent.getServletContext().getRealPath("/");
        if (webRootPath == null) {
            try {
                webRootPath = servletContextEvent.getServletContext().getResource("/").getFile();
            }
            catch (MalformedURLException e) {
                logger.errorMessage("\u83b7\u53d6WEBROOT\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        logger.logMessage(LogLevel.INFO, "TINY_WEBROOT\uff1a[{0}]", new Object[]{webRootPath});
        ConfigurationUtil.getConfigurationManager().setApplicationProperty("TINY_WEBROOT", webRootPath);
        logger.logMessage(LogLevel.INFO, "\u5e94\u7528\u53c2\u6570<TINY_WEBROOT>=<{}>", new Object[]{webRootPath});
        logger.logMessage(LogLevel.INFO, "ServerContextName\uff1a[{0}]", new Object[]{servletContextEvent.getServletContext().getServletContextName()});
        logger.logMessage(LogLevel.INFO, "WEB\u73af\u5883\u5c5e\u6027\u7ed3\u675f");
        InputStream inputStream = this.getClass().getResourceAsStream("/application.xml");
        if (inputStream == null) {
            try {
                File file = new File(webRootPath + "/classes/application.xml");
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                logger.errorMessage("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a\uff01", (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        this.loadSpringBeans();
        this.application = new ApplicationDefault(inputStream, true);
        this.application.start();
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u542f\u52a8\u5b8c\u6210\u3002");
    }

    private void loadSpringBeans() {
        logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dSpring Bean\u6587\u4ef6\u5f00\u59cb...");
        FileResolverImpl fileResolver = new FileResolverImpl();
        InputStream inputStream = this.getClass().getResourceAsStream("/application.xml");
        this.loadFileResolverConfig((FileResolver)fileResolver, inputStream);
        fileResolver.addFileProcessor((FileProcessor)new SpringBeansFileProcessor());
        fileResolver.resolve();
        logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dSpring Bean\u6587\u4ef6\u7ed3\u675f\u3002");
    }

    private void loadFileResolverConfig(FileResolver fileResolver, InputStream inputStream) {
        XmlStringParser parser;
        XmlNode root;
        PathFilter filter;
        String resolve;
        String applicationConfig = "";
        if (inputStream != null) {
            try {
                applicationConfig = StreamUtil.readText((InputStream)inputStream, (String)"UTF-8", (boolean)false);
            }
            catch (Exception e) {
                logger.errorMessage("\u8f7d\u5165\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}\uff01", (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        if ((resolve = ((XmlNode)(filter = new PathFilter((Node)(root = (XmlNode)(parser = new XmlStringParser()).parse(applicationConfig).getRoot()))).findNode("/application/file-resolver-configuration")).getAttribute("resolve-classpath")) == null || resolve.length() == 0) {
            resolve = "true";
        }
        List skipList = filter.findNodeList("/application/file-resolver-configuration/skip-patterns/skip-pattern");
        for (XmlNode node : skipList) {
            fileResolver.addSkipPathPattern(node.getAttribute("pattern"));
        }
        List classPathList = filter.findNodeList("/application/file-resolver-configuration/class-paths/class-path");
        for (XmlNode classPath : classPathList) {
            fileResolver.addManualClassPath(classPath.getAttribute("path"));
        }
        for (XmlNode node : skipList) {
            fileResolver.addSkipPathPattern(node.getAttribute("pattern"));
        }
    }
}

