/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.ExceptionUtil;
import org.tinygroup.context.Context;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.TinyFilter;
import org.tinygroup.weblayer.TinyFilterManager;
import org.tinygroup.weblayer.TinyProcessorManager;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.exceptionhandler.WebExceptionHandlerManager;
import org.tinygroup.weblayer.webcontext.CommitMonitor;
import org.tinygroup.weblayer.webcontext.SimpleWebContext;
import org.tinygroup.weblayer.webcontext.TwoPhaseCommitWebContext;
import org.tinygroup.weblayer.webcontext.buffered.BufferedWebContext;
import org.tinygroup.weblayer.webcontext.cache.PageCacheWebContext;
import org.tinygroup.weblayer.webcontext.lazycommit.LazyCommitWebContext;
import org.tinygroup.weblayer.webcontext.util.WebContextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyFilterHandler {
    private static final Logger logger = LoggerFactory.getLogger(TinyFilterHandler.class);
    private TinyFilterManager tinyFilterManager;
    private TinyProcessorManager tinyProcessorManager;
    private FilterChain filterChain;
    private String servletPath;
    private WebContext context;
    private static final String WEB_CONTEXT_OWNER_KEY = "_web_context_owner_";

    public TinyFilterHandler(String servletPath, FilterChain filterChain, WebContext context, TinyFilterManager tinyFilterManager, TinyProcessorManager tinyProcessorManager) {
        this.context = context;
        this.filterChain = filterChain;
        this.servletPath = servletPath;
        this.tinyFilterManager = tinyFilterManager;
        this.tinyProcessorManager = tinyProcessorManager;
    }

    public WebContext getContext() {
        return this.context;
    }

    public void setContext(WebContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tinyFilterProcessor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        WebContext wrapperContext;
        List<TinyFilter> tinyFilters;
        block7: {
            block6: {
                logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84\uff1a<{}>", new Object[]{this.servletPath});
                tinyFilters = this.tinyFilterManager.getTinyFiltersWithUrl(this.servletPath);
                wrapperContext = null;
                wrapperContext = this.getWebContext(this.context, tinyFilters, request, response);
                if (!this.isRequestFinished(wrapperContext) && !this.isPageCached(wrapperContext)) break block6;
                this.postProcess(wrapperContext, tinyFilters);
                return;
            }
            if (this.tinyProcessorManager.execute(this.servletPath, wrapperContext)) break block7;
            this.giveUpControl(wrapperContext);
            this.postProcess(wrapperContext, tinyFilters);
            return;
        }
        try {
            this.processFlow(wrapperContext);
            this.postProcess(wrapperContext, tinyFilters);
        }
        catch (Throwable e) {
            try {
                logger.errorMessage("\u6267\u884cWebContext\u5904\u7406\u6d41\u7a0b\u65f6\u51fa\u9519\uff0c\u539f\u56e0\uff1a{}", e, new Object[]{e.getMessage()});
                this.handleException(wrapperContext, e, this.context.getRequest(), this.context.getResponse());
                this.postProcess(wrapperContext, tinyFilters);
            }
            catch (Throwable throwable) {
                this.postProcess(wrapperContext, tinyFilters);
                throw throwable;
            }
        }
    }

    private boolean isPageCached(WebContext wrapperContext) {
        PageCacheWebContext pageCacheWebContext = WebContextUtil.findWebContext(wrapperContext, PageCacheWebContext.class);
        String accessPath = (String)wrapperContext.get("TINY_REQUEST_URI");
        if (pageCacheWebContext != null) {
            return pageCacheWebContext.isCached(accessPath);
        }
        return false;
    }

    private void giveUpControl(WebContext wrapperContext) throws IOException, ServletException {
        logger.logMessage(LogLevel.DEBUG, "\u653e\u5f03\u63a7\u5236\uff0c\u5c06\u63a7\u5236\u6743\u8fd4\u56de\u7ed9servlet engine,\u8bf7\u6c42\u8def\u5f84\uff1a<{}>", new Object[]{this.servletPath});
        BufferedWebContext brc = WebContextUtil.findWebContext(wrapperContext, BufferedWebContext.class);
        if (brc != null) {
            try {
                brc.setBuffering(false);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        try {
            wrapperContext.getResponse().setContentType(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.filterChain.doFilter((ServletRequest)wrapperContext.getRequest(), (ServletResponse)wrapperContext.getResponse());
    }

    private WebContext getWebContext(WebContext context, List<TinyFilter> tinyFilters, HttpServletRequest request, HttpServletResponse response) {
        WebContext webContext = WebContextUtil.getWebContext(context.getRequest());
        if (webContext == null) {
            webContext = this.createWrapperContext(context, tinyFilters, request, response);
            context.getRequest().setAttribute(WEB_CONTEXT_OWNER_KEY, (Object)this);
        }
        return webContext;
    }

    private WebContext createWrapperContext(WebContext context, List<TinyFilter> tinyFilters, HttpServletRequest request, HttpServletResponse response) {
        SimpleWebContext innerWebContext;
        WebContext wrapperedContext = innerWebContext = new SimpleWebContext(context, this, request, response);
        WebContextUtil.setWebContext(wrapperedContext);
        logger.logMessage(LogLevel.DEBUG, "tiny-filter\u5f00\u59cb\u8fdb\u884c\u524d\u7f6e\u5904\u7406\u64cd\u4f5c");
        for (TinyFilter filter : tinyFilters) {
            wrapperedContext = filter.wrapContext(wrapperedContext);
            if (filter == null) continue;
            logger.logMessage(LogLevel.DEBUG, "tiny-filter<{}>\u8fdb\u884c\u524d\u7f6e\u5904\u7406", new Object[]{filter.getClass().getName()});
            filter.preProcess(wrapperedContext);
            WebContextUtil.setWebContext(wrapperedContext);
        }
        innerWebContext.setTopWebContext(wrapperedContext);
        logger.logMessage(LogLevel.DEBUG, "tiny-filter\u524d\u7f6e\u5904\u7406\u64cd\u4f5c\u7ed3\u675f");
        logger.logMessage(LogLevel.DEBUG, "Created a new web context: {}", (Context)wrapperedContext);
        return wrapperedContext;
    }

    private void handleException(WebContext webContext, Throwable e, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (webContext != null) {
            request = webContext.getRequest();
            response = webContext.getResponse();
        }
        try {
            response.setStatus(500);
        }
        catch (Exception ee) {
            // empty catch block
        }
        this.clearBuffer(response);
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
        String originalExceptionMessage = rootCause.getClass().getSimpleName() + ": " + rootCause.getMessage();
        logger.errorMessage("Full stack trace of the error " + originalExceptionMessage, e);
        WebExceptionHandlerManager exceptionHandlerManager = (WebExceptionHandlerManager)SpringUtil.getBean((String)"webExceptionHandlerManager");
        exceptionHandlerManager.handler(rootCause, webContext);
    }

    private void clearBuffer(HttpServletResponse response) {
        if (!response.isCommitted()) {
            response.resetBuffer();
        }
    }

    private boolean isRequestFinished(WebContext webContext) {
        LazyCommitWebContext lcrc = WebContextUtil.findWebContext(webContext, LazyCommitWebContext.class);
        return lcrc != null && lcrc.isRedirected();
    }

    private void processFlow(WebContext context) {
    }

    private void postProcess(WebContext webContext, List<TinyFilter> tinyFilters) {
        if (webContext == null) {
            return;
        }
        try {
            if (this == webContext.getRequest().getAttribute(WEB_CONTEXT_OWNER_KEY)) {
                webContext.getRequest().removeAttribute(WEB_CONTEXT_OWNER_KEY);
                this.commitWebRequest(webContext, tinyFilters);
            }
        }
        catch (Exception e) {
            logger.errorMessage("Exception occurred while commit rundata", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitWebRequest(WebContext webContext, List<TinyFilter> tinyFilters) {
        CommitMonitor monitor;
        logger.logMessage(LogLevel.DEBUG, "tiny-filter\u5f00\u59cb\u8fdb\u884c\u540e\u7f6e\u5904\u7406\u64cd\u4f5c");
        CommitMonitor commitMonitor = monitor = this.getCommitMonitor(webContext);
        synchronized (commitMonitor) {
            if (!monitor.isCommitted()) {
                boolean doCommitHeaders = !monitor.isHeadersCommitted();
                monitor.setCommitted(true);
                HttpServletRequest request = webContext.getRequest();
                int size = tinyFilters.size() - 1;
                WebContext wrapperedContext = webContext;
                for (int i = size; i >= 0; --i) {
                    TinyFilter filter = tinyFilters.get(i);
                    if (filter != null) {
                        logger.logMessage(LogLevel.DEBUG, "tiny-filter<{}>\u8fdb\u884c\u540e\u7f6e\u5904\u7406", new Object[]{filter.getClass().getName()});
                        if (wrapperedContext instanceof TwoPhaseCommitWebContext && doCommitHeaders) {
                            ((TwoPhaseCommitWebContext)wrapperedContext).commitHeaders();
                        }
                        filter.postProcess(wrapperedContext);
                    }
                    wrapperedContext = wrapperedContext.getWrappedWebContext();
                }
                WebContextUtil.removeWebContext(request);
                logger.logMessage(LogLevel.DEBUG, "Committed request: {}", new Object[]{request});
            }
        }
        logger.logMessage(LogLevel.DEBUG, "tiny-filter\u540e\u7f6e\u5904\u7406\u64cd\u4f5c\u7ed3\u675f");
    }

    public String getServletPath() {
        return this.servletPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitHeaders(WebContext wrapperedContext) {
        CommitMonitor monitor;
        CommitMonitor commitMonitor = monitor = this.getCommitMonitor(wrapperedContext);
        synchronized (commitMonitor) {
            if (!monitor.isHeadersCommitted()) {
                monitor.setHeadersCommitted(true);
                for (WebContext rc = wrapperedContext; rc != null; rc = rc.getWrappedWebContext()) {
                    if (!(rc instanceof TwoPhaseCommitWebContext)) continue;
                    TwoPhaseCommitWebContext tpc = (TwoPhaseCommitWebContext)rc;
                    logger.logMessage(LogLevel.TRACE, "Committing headers: {}", new Object[]{tpc.getClass().getSimpleName()});
                    tpc.commitHeaders();
                }
            }
        }
    }

    private CommitMonitor getCommitMonitor(WebContext webContext) {
        CommitMonitor monitor = WebContextUtil.findWebContext(webContext, SimpleWebContext.class);
        return (CommitMonitor)Assert.assertNotNull((Object)monitor, (String)"no monitor", (Object[])new Object[0]);
    }
}

