/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.configmanager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.config.Configuration;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyProcessorConfigManager
implements Configuration {
    public static final String TINY_PROCESSOR_CONFIGMANAGER = "tinyProcessorConfigManager";
    private static final String TINY_PROCESSOR_NODE_PATH = "/application/tiny-processors";
    private List<XmlNode> configs = new ArrayList<XmlNode>();
    private XmlNode applicationConfig;
    private XmlNode componentConfig;
    private static Logger logger = LoggerFactory.getLogger(TinyProcessorConfigManager.class);

    public void addConfig(FileObject fileObject) {
        String filePath = fileObject.getPath();
        logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dtiny-processor\u5904\u7406\u5668\u914d\u7f6e\u6587\u4ef6[{0}] ....", new Object[]{filePath});
        try {
            String content = FileUtil.readStreamContent((InputStream)fileObject.getInputStream(), (String)"UTF-8");
            logger.logMessage(LogLevel.INFO, "tiny-processor\u5904\u7406\u5668\u914d\u7f6e\u6587\u4ef6<{0}>\u52a0\u8f7d\u5b8c\u6210\u3002.", new Object[]{filePath});
            XmlNode root = (XmlNode)new XmlStringParser().parse(content).getRoot();
            this.configs.add(root);
        }
        catch (Exception e) {
            logger.errorMessage("\u8f7d\u5165tiny-processor\u914d\u7f6e\u6587\u4ef6<{}>\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e, new Object[]{filePath});
            throw new RuntimeException(e);
        }
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public List<XmlNode> getConfigs() {
        return this.configs;
    }

    public String getApplicationNodePath() {
        return TINY_PROCESSOR_NODE_PATH;
    }

    public String getComponentConfigPath() {
        return "/tinyprocessor.config.xml";
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }
}

