/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.servicemapping.ServiceMappingManager;
import org.tinygroup.weblayer.servicemapping.config.ServiceViewMappings;
import org.tinygroup.xstream.XStreamFactory;

public class ServiceMappingFileProcessor
extends AbstractFileProcessor {
    private static final String SERVICEMAPPING_EXT_FILENAMES = ".servicemapping.xml";

    public boolean isMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(SERVICEMAPPING_EXT_FILENAMES);
    }

    public void process() {
        ServiceMappingManager manager = (ServiceMappingManager)SpringUtil.getBean((String)"serviceMappingMananger");
        XStream stream = XStreamFactory.getXStream((String)"weblayer");
        for (FileObject fileObject : this.fileObjects) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728ServiceMappings\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            try {
                ServiceViewMappings mappings = (ServiceViewMappings)stream.fromXML(fileObject.getInputStream());
                manager.addServiceMappings(mappings);
            }
            catch (Exception e) {
                logger.errorMessage("\u8bfb\u53d6ServiceMappings\u6587\u4ef6[{0}]\u51fa\u9519", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            logger.logMessage(LogLevel.INFO, "\u8bfb\u53d6ServiceMappings\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

