/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.filter;

import java.util.List;
import org.tinygroup.cache.Cache;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.cache.CacheOperater;
import org.tinygroup.weblayer.webcontext.cache.PageCacheWebContext;
import org.tinygroup.weblayer.webcontext.cache.impl.PageCacheWebContextImpl;
import org.tinygroup.xmlparser.node.XmlNode;

public class PageCacheTinyFilter
extends AbstractTinyFilter {
    private static final String DEFAULT_CACHE_BEAN_NAME = "cacheFactoryBean";
    private static final String CACHE_BEAN_NAME = "cacheBeanName";
    private static final String PAGE_CACHE_CONFIG = "page-cache-config";
    CacheOperater operater;

    public void initTinyFilter() {
        super.initTinyFilter();
        this.init();
    }

    private void init() {
        String cacheBeanName = StringUtil.defaultIfEmpty((String)this.get(CACHE_BEAN_NAME), (String)DEFAULT_CACHE_BEAN_NAME);
        Cache cache = (Cache)SpringUtil.getBean((String)cacheBeanName);
        this.operater = new CacheOperater(cache);
        ConfigurationManager appConfigManager = ConfigurationUtil.getConfigurationManager();
        XmlNode parserNode = (XmlNode)appConfigManager.getApplicationConfig().getSubNode(PAGE_CACHE_CONFIG);
        if (parserNode != null) {
            this.parserExtraConfig(parserNode);
        }
    }

    public void preProcess(WebContext context) {
        PageCacheWebContext webContext = (PageCacheWebContext)context;
        String accessPath = (String)webContext.get("TINY_REQUEST_URI");
        if (webContext.isCached(accessPath)) {
            webContext.cacheOutputPage(accessPath);
        }
    }

    public void postProcess(WebContext context) {
        PageCacheWebContext webContext = (PageCacheWebContext)context;
        String accessPath = (String)webContext.get("TINY_REQUEST_URI");
        webContext.putCachePage(accessPath);
    }

    public WebContext getAlreadyWrappedContext(WebContext wrappedContext) {
        PageCacheWebContextImpl webContext = new PageCacheWebContextImpl(wrappedContext);
        webContext.setCacheOperater(this.operater);
        return webContext;
    }

    protected void parserExtraConfig(XmlNode parserNode) {
        NameFilter nameFilter = new NameFilter((Node)parserNode);
        List mappings = nameFilter.findNodeList("cache-mapping");
        for (XmlNode xmlNode : mappings) {
            String patternStr = xmlNode.getAttribute("pattern");
            Long timeToLived = Long.parseLong(xmlNode.getAttribute("time-live"));
            XmlNode paramNode = (XmlNode)xmlNode.getSubNode("param");
            String param = null;
            if (paramNode != null) {
                param = paramNode.getAttribute("name");
            }
            this.operater.addMapping(patternStr, param, timeToLived);
        }
    }
}

