/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.filter;

import org.springframework.beans.PropertyEditorRegistrar;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.util.ParserXmlNodeUtil;
import org.tinygroup.weblayer.webcontext.parser.impl.ParserWebContextImpl;
import org.tinygroup.weblayer.webcontext.parser.impl.PropertyEditorRegistrarsSupport;
import org.tinygroup.weblayer.webcontext.parser.upload.ParameterParserFilter;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadService;
import org.tinygroup.xmlparser.node.XmlNode;

public class ParserTinyFilter
extends AbstractTinyFilter {
    private static final String PROPERTY = "property";
    private static final boolean CONVERTER_QUIET_DEFAULT = true;
    private static final String CONVERTER_QUIET_PARAM = "converterQuietParam";
    private static final String URL_CASE_FOLDING_DEFAULT = "lower_with_underscores";
    private static final String CASE_FOLDING = "caseFolding";
    private static final boolean AUTO_UPLOAD_DEFAULT = true;
    private static final String AUTO_UPLOAD = "autoUpload";
    private static final boolean UNESCAPE_PARAMETERS_DEFAULT = true;
    private static final String UNESCAPE_PARAMETERS = "unescapeParameters";
    private static final boolean USE_SERVLET_ENGINE_PARSER_DEFAULT = false;
    private static final String USE_SERVLET_ENGINE_PARSER = "useServletEngineParser";
    private static final boolean USE_BODY_ENCODING_FOR_URI_DEFAULT = true;
    private static final String USE_BODY_ENCODING_FOR_URI = "useBodyEncodingForUri";
    private static final String URI_ENCODING_DEFAULT = "UTF-8";
    private static final String URI_ENCODING = "uriEncoding";
    private static final boolean TRIMMING_DEFAULT = true;
    private static final String TRIMMING = "trimming";
    private static final String HTML_FIELD_SUFFIX_DEFAULT = ".~html";
    private static final String HTML_FIELD_SUFFIX = "htmlFieldSuffix";
    private static final String PARSER_CONFIG = "parser";
    private static final String PROPERTY_EDITOR = "property-editor";
    private static final String PARAM_PARSER_FILTER = "param-parser-filter";
    private static final String UPLOAD_SERVICE = "upload-service";
    private PropertyEditorRegistrarsSupport propertyEditorRegistrars = new PropertyEditorRegistrarsSupport();
    private Boolean converterQuiet;
    private String caseFolding;
    private Boolean autoUpload;
    private Boolean unescapeParameters;
    private Boolean useServletEngineParser;
    private Boolean useBodyEncodingForURI;
    private String uriEncoding;
    private Boolean trimming;
    private ParameterParserFilter[] filters;
    private String htmlFieldSuffix;
    private UploadService uploadService;

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] registrars) {
        this.propertyEditorRegistrars.setPropertyEditorRegistrars(registrars);
    }

    public void setConverterQuiet(boolean converterQuiet) {
        this.converterQuiet = converterQuiet;
    }

    public void setCaseFolding(String caseFolding) {
        this.caseFolding = caseFolding;
    }

    public void setAutoUpload(boolean autoUpload) {
        this.autoUpload = autoUpload;
    }

    public void setUnescapeParameters(boolean unescapeParameters) {
        this.unescapeParameters = unescapeParameters;
    }

    public void setUseServletEngineParser(boolean useServletEngineParser) {
        this.useServletEngineParser = useServletEngineParser;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
    }

    public void setURIEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public void setTrimming(boolean trimming) {
        this.trimming = trimming;
    }

    public void setParameterParserFilters(ParameterParserFilter[] filters) {
        this.filters = filters;
    }

    public void setHtmlFieldSuffix(String htmlFieldSuffix) {
        this.htmlFieldSuffix = htmlFieldSuffix;
    }

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void initTinyFilter() {
        super.initTinyFilter();
        this.init();
    }

    private void init() {
        if (this.converterQuiet == null) {
            this.converterQuiet = (Boolean)ObjectUtil.defaultIfNull((Object)Boolean.parseBoolean(this.get(CONVERTER_QUIET_PARAM)), (Object)true);
        }
        if (this.caseFolding == null) {
            this.caseFolding = StringUtil.defaultIfEmpty((String)this.get(CASE_FOLDING), (String)URL_CASE_FOLDING_DEFAULT).toLowerCase();
        }
        if (this.autoUpload == null) {
            this.autoUpload = (Boolean)ObjectUtil.defaultIfNull((Object)Boolean.parseBoolean(this.get(AUTO_UPLOAD)), (Object)true);
        }
        if (this.unescapeParameters == null) {
            this.unescapeParameters = (Boolean)ObjectUtil.defaultIfNull((Object)Boolean.parseBoolean(this.get(UNESCAPE_PARAMETERS)), (Object)true);
        }
        if (this.useServletEngineParser == null) {
            this.useServletEngineParser = (Boolean)ObjectUtil.defaultIfNull((Object)Boolean.parseBoolean(this.get(USE_SERVLET_ENGINE_PARSER)), (Object)false);
        }
        if (this.useBodyEncodingForURI == null) {
            this.useBodyEncodingForURI = (Boolean)ObjectUtil.defaultIfNull((Object)Boolean.parseBoolean(this.get(USE_BODY_ENCODING_FOR_URI)), (Object)true);
        }
        if (this.uriEncoding == null) {
            this.uriEncoding = (String)ObjectUtil.defaultIfNull((Object)this.get(URI_ENCODING), (Object)URI_ENCODING_DEFAULT);
        }
        if (this.trimming == null) {
            this.trimming = (Boolean)ObjectUtil.defaultIfNull((Object)Boolean.parseBoolean(this.get(TRIMMING)), (Object)true);
        }
        if (this.htmlFieldSuffix == null) {
            this.htmlFieldSuffix = StringUtil.defaultIfEmpty((String)this.get(HTML_FIELD_SUFFIX), (String)HTML_FIELD_SUFFIX_DEFAULT);
        }
        ConfigurationManager appConfigManager = ConfigurationUtil.getConfigurationManager();
        XmlNode parserNode = (XmlNode)appConfigManager.getApplicationConfig().getSubNode(PARSER_CONFIG);
        this.parserExtraConfig(parserNode);
    }

    protected void parserExtraConfig(XmlNode parserNode) {
        if (this.propertyEditorRegistrars.size() == 0) {
            PropertyEditorRegistrar[] strars = ParserXmlNodeUtil.parseConfigToArray(PROPERTY_EDITOR, PROPERTY, parserNode, PropertyEditorRegistrar.class);
            this.propertyEditorRegistrars.setPropertyEditorRegistrars(strars);
        }
        if (this.filters == null) {
            this.setParameterParserFilters(ParserXmlNodeUtil.parseConfigToArray(PARAM_PARSER_FILTER, parserNode, ParameterParserFilter.class));
        }
        this.setUploadService(ParserXmlNodeUtil.parseConfigToObject(UPLOAD_SERVICE, PROPERTY, parserNode, UploadService.class, new String[0]));
    }

    public void preProcess(WebContext context) {
    }

    public void postProcess(WebContext context) {
    }

    public WebContext getAlreadyWrappedContext(WebContext wrappedContext) {
        ParserWebContextImpl parserWebContext = new ParserWebContextImpl(wrappedContext);
        parserWebContext.setPropertyEditorRegistrar(this.propertyEditorRegistrars);
        parserWebContext.setConverterQuiet(this.converterQuiet);
        parserWebContext.setAutoUpload(this.autoUpload);
        parserWebContext.setCaseFolding(this.caseFolding);
        parserWebContext.setUnescapeParameters(this.unescapeParameters);
        parserWebContext.setUseServletEngineParser(this.useServletEngineParser);
        parserWebContext.setUseBodyEncodingForURI(this.useBodyEncodingForURI);
        parserWebContext.setURIEncoding(this.uriEncoding);
        parserWebContext.setTrimming(this.trimming);
        if (this.autoUpload.booleanValue()) {
            parserWebContext.setUploadService(this.uploadService);
        }
        if (!ArrayUtil.isEmptyArray((Object)this.filters)) {
            parserWebContext.setParameterParserFilters(this.filters);
        }
        parserWebContext.setHtmlFieldSuffix(this.htmlFieldSuffix);
        return parserWebContext;
    }

    public int getOrder() {
        return -2147483548;
    }
}

