/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.filter;

import java.util.Collection;
import java.util.List;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.util.ParserXmlNodeUtil;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteCondition;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteRule;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitution;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitutionHandler;
import org.tinygroup.weblayer.webcontext.rewrite.impl.RewriteWebContextImpl;
import org.tinygroup.xmlparser.node.XmlNode;

public class RewriteTinyFilter
extends AbstractTinyFilter {
    private static final String REWRITE_CONFIG = "rewrite";
    private RewriteRule[] rules;

    public void setRules(RewriteRule[] rules) {
        this.rules = rules;
    }

    public void initTinyFilter() {
        super.initTinyFilter();
        this.initRules();
    }

    private void initRules() {
        ConfigurationManager appConfigManager = ConfigurationUtil.getConfigurationManager();
        XmlNode parserNode = (XmlNode)appConfigManager.getApplicationConfig().getSubNode(REWRITE_CONFIG);
        this.parserExtraConfig(parserNode);
    }

    protected void parserExtraConfig(XmlNode parserNode) {
        if (this.rules == null) {
            Assert.assertNotNull((Object)parserNode, (String)"rewrite config must not null", (Object[])new Object[0]);
            NameFilter nameFilter = new NameFilter((Node)parserNode);
            List ruleNodes = nameFilter.findNodeList("rule");
            if (!CollectionUtil.isEmpty((Collection)ruleNodes)) {
                this.rules = new RewriteRule[ruleNodes.size()];
                for (int i = 0; i < ruleNodes.size(); ++i) {
                    XmlNode ruleNode = (XmlNode)ruleNodes.get(i);
                    RewriteRule rule = new RewriteRule();
                    rule.setPattern(ruleNode.getAttribute("pattern"));
                    rule.setConditions(this.ruleConditions(ruleNode));
                    rule.setSubstitution(this.ruleSubstitution(ruleNode));
                    rule.setHandlers(this.ruleHandlers(ruleNode));
                    this.rules[i] = rule;
                    try {
                        rule.afterPropertiesSet();
                        continue;
                    }
                    catch (Exception e) {
                        logger.errorMessage("initializingBean error", (Throwable)e);
                        throw new RuntimeException("initializingBean error", e);
                    }
                }
            }
        }
    }

    private Object[] ruleHandlers(XmlNode ruleNode) {
        return ParserXmlNodeUtil.parseConfigToArray("rewrite-handler", ruleNode, RewriteSubstitutionHandler.class);
    }

    private RewriteSubstitution ruleSubstitution(XmlNode ruleNode) {
        RewriteSubstitution substitution = ParserXmlNodeUtil.parseConfigToObject("substitution", null, ruleNode, RewriteSubstitution.class, "uri", "flags");
        RewriteSubstitution.Parameter[] parameters = ParserXmlNodeUtil.parseConfigToArray("parameter", ruleNode, RewriteSubstitution.Parameter.class, "key", "value");
        substitution.setParameters(parameters);
        return substitution;
    }

    private RewriteCondition[] ruleConditions(XmlNode ruleNode) {
        return ParserXmlNodeUtil.parseConfigToArray("condition", ruleNode, RewriteCondition.class, "test", "flags", "pattern");
    }

    public void preProcess(WebContext context) {
        RewriteWebContextImpl rewrite = (RewriteWebContextImpl)context;
        rewrite.prepare();
    }

    public void postProcess(WebContext context) {
    }

    public WebContext getAlreadyWrappedContext(WebContext wrappedContext) {
        return new RewriteWebContextImpl(wrappedContext, this.rules);
    }

    public int getOrder() {
        return -2147483048;
    }
}

