/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.flow;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import org.tinygroup.context.Context;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.flow.ComponentInterface;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.velocity.VelocityHelper;
import org.tinygroup.velocity.impl.VelocityHelperImpl;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.WebContext;

public class FullContextUrlRedirect
implements ComponentInterface {
    private static final Logger logger = LoggerFactory.getLogger(FullContextUrlRedirect.class);
    private String path;
    private static final String PAGELET_EXT_FILE_NAME = ".pagelet";
    private static final String PAGE_EXT_FILE_NAME = ".page";
    private String templeteWithLayout = ".page";
    private String template = ".pagelet";
    private FullContextFileRepository fullContextFileRepository;
    private VelocityHelper velocityHelper;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void init() {
        this.fullContextFileRepository = (FullContextFileRepository)SpringUtil.getBean((String)"fullContextFileRepository");
        VelocityHelperImpl velocityHelperImpl = (VelocityHelperImpl)SpringUtil.getBean((String)"velocityHelper");
        velocityHelperImpl.setFullContextFileRepository(this.fullContextFileRepository);
        this.velocityHelper = velocityHelperImpl;
        if (this.templeteWithLayout == null || this.templeteWithLayout.length() == 0) {
            this.templeteWithLayout = PAGE_EXT_FILE_NAME;
        }
        if (this.template == null || this.template.length() == 0) {
            this.template = PAGELET_EXT_FILE_NAME;
        }
    }

    public void doExecute(Context context) throws FileNotFoundException, IOException, Exception {
        boolean isPagelet = false;
        if (this.path.endsWith(PAGELET_EXT_FILE_NAME)) {
            isPagelet = true;
            this.path = this.path.substring(0, this.path.length() - PAGELET_EXT_FILE_NAME.length()) + PAGE_EXT_FILE_NAME;
        }
        FileObject fileObject = this.fullContextFileRepository.getFileObject(this.path);
        WebContext webContent = null;
        if (!(context instanceof WebContext)) {
            return;
        }
        webContent = (WebContext)context;
        if (fileObject != null && fileObject.isExist()) {
            webContent.put("uiengine", SpringUtil.getBean((String)"uiComponentManager"));
            if (isPagelet) {
                this.velocityHelper.processTempleate((Context)webContent, (Writer)webContent.getResponse().getWriter(), this.path);
            } else {
                this.velocityHelper.processTempleateWithLayout((Context)webContent, (Writer)webContent.getResponse().getWriter(), this.path);
            }
            return;
        }
        webContent.getResponse().sendError(404);
    }

    public void execute(Context context) {
        try {
            this.init();
            this.doExecute(context);
        }
        catch (Exception e) {
            logger.errorMessage("\u9875\u9762\u8df3\u8f6c\u51fa\u9519", (Throwable)e);
        }
    }
}

