/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.context.Context;
import org.tinygroup.convert.objectjson.jackson.ObjectToJson;
import org.tinygroup.convert.objectxml.xstream.ObjectToXml;
import org.tinygroup.event.Event;
import org.tinygroup.event.Parameter;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.event.ServiceRequest;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.servicemapping.ServiceMappingManager;

public class ServiceTinyProcessor
extends AbstractTinyProcessor {
    ServiceMappingManager manager;
    ObjectToXml<Object> objectToXml = new ObjectToXml();
    ObjectToJson<Object> objectToJson = new ObjectToJson(JsonSerialize.Inclusion.NON_NULL);

    public ServiceMappingManager getManager() {
        return this.manager;
    }

    public void setManager(ServiceMappingManager manager) {
        this.manager = manager;
    }

    private Object callService(String serviceId, Context context) {
        CEPCore core = (CEPCore)SpringUtil.getBean((String)"cepcore");
        Event event = new Event();
        ServiceRequest sq = new ServiceRequest();
        sq.setServiceId(serviceId);
        sq.setContext(context);
        event.setServiceRequest(sq);
        core.process(event);
        ServiceInfo info = core.getServiceInfo(serviceId);
        List resultsParam = info.getResults();
        if (resultsParam.size() == 0) {
            return null;
        }
        return event.getServiceRequest().getContext().get(((Parameter)resultsParam.get(0)).getName());
    }

    public void reallyProcess(String urlString, WebContext context) {
        int lastSplash = urlString.lastIndexOf(47);
        int lastDot = urlString.lastIndexOf(46);
        try {
            String serviceId = urlString.substring(lastSplash + 1, lastDot);
            Object result = this.callService(serviceId, context);
            if (urlString.endsWith("servicexml") && result != null) {
                context.getResponse().getWriter().write(this.objectToXml.convert(result));
            } else if (urlString.endsWith(".servicejson") && result != null) {
                context.getResponse().getWriter().write(this.objectToJson.convert(result));
            } else if (urlString.endsWith(".servicepage")) {
                String path = this.manager.getUrl(serviceId);
                this.checkPath(serviceId, path);
                context.getRequest().getRequestDispatcher(path).forward((ServletRequest)context.getRequest(), (ServletResponse)context.getResponse());
            } else if (urlString.endsWith(".servicepagelet")) {
                String path = this.manager.getUrl(serviceId);
                this.checkPath(serviceId, path);
                if (path.endsWith(".page")) {
                    path = path + "let";
                }
                context.getRequest().getRequestDispatcher(path).forward((ServletRequest)context.getRequest(), (ServletResponse)context.getResponse());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkPath(String serviceId, String path) {
        if (path == null) {
            throw new RuntimeException(serviceId + "\u5bf9\u5e94\u7684\u5c55\u73b0\u89c6\u56fe\u4e0d\u5b58\u5728\uff01");
        }
    }
}

