/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.FilterWrapper;
import org.tinygroup.weblayer.TinyFilterHandler;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.impl.TinyFilterChain;
import org.tinygroup.weblayer.impl.TinyFilterConfig;
import org.tinygroup.xmlparser.node.XmlNode;

public class TinyFilterWrapper
extends AbstractTinyFilter
implements FilterWrapper {
    private static final String SPLIT_CHAR = ",";
    private List<Filter> filters = new ArrayList<Filter>();
    private static final Logger logger = LoggerFactory.getLogger(TinyFilterWrapper.class);
    private List<String> filterBeanNames = new ArrayList<String>();

    protected void initParam(XmlNode xmlNode) {
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List initParamNodes = nameFilter.findNodeList("init-param");
        for (XmlNode initParamNode : initParamNodes) {
            String name = initParamNode.getAttribute("name");
            String value = initParamNode.getAttribute("value");
            if ("filter_beans".equals(name) && !StringUtil.isBlank((String)value)) {
                String[] beanNames = value.split(SPLIT_CHAR);
                StringBuffer buffer = new StringBuffer();
                for (String beanName : beanNames) {
                    if (this.filterBeanNames.contains(beanName)) continue;
                    buffer.append(beanName).append(SPLIT_CHAR);
                    this.filterBeanNames.add(beanName);
                }
                if (buffer.length() > 0) {
                    this.initParamMap.put(name, buffer.deleteCharAt(buffer.length() - 1).toString());
                }
            } else {
                this.initParamMap.put(name, value);
            }
            logger.logMessage(LogLevel.DEBUG, "<{}>\u7684\u521d\u59cb\u5316\u53c2\u6570name='{}',value='{}'", new Object[]{this.getClass().getName(), name, value});
        }
    }

    public void initTinyFilter() {
        super.initTinyFilter();
        logger.logMessage(LogLevel.INFO, "filter\u5305\u88c5\u7c7b\u5f00\u59cb\u5b9e\u4f8b\u5316filter");
        for (String beanName : this.filterBeanNames) {
            Filter filter = (Filter)SpringUtil.getBean((String)beanName);
            if (filter == null) continue;
            logger.logMessage(LogLevel.INFO, "\u5b9e\u4f8b\u5316filter\uff1a<{}>", new Object[]{beanName});
            try {
                filter.init((FilterConfig)new TinyFilterConfig(this.getInitParamMap()));
            }
            catch (ServletException e) {
                logger.errorMessage("\u521d\u59cb\u5316filter:{}\u51fa\u9519", (Throwable)e, new Object[]{beanName});
                throw new RuntimeException("\u521d\u59cb\u5316filter\u51fa\u9519", e);
            }
            this.filters.add(filter);
        }
        logger.logMessage(LogLevel.INFO, "filter\u5305\u88c5\u7c7b\u5b9e\u4f8b\u5316filter\u7ed3\u675f");
    }

    public void destoryTinyFilter() {
        super.destoryTinyFilter();
        for (Filter filter : this.filters) {
            filter.destroy();
        }
    }

    public void filterWrapper(WebContext context, TinyFilterHandler hander) {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        String servletPath = hander.getServletPath();
        if (this.isMatch(servletPath)) {
            TinyFilterChain filterChain = new TinyFilterChain(this.filters, hander);
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                logger.errorMessage(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u8fc7\u6ee4\u5668\u94fe\u6267\u884c\u51fa\u9519", e);
            }
        }
    }
}

