/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.listener;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.config.impl.AbstractConfiguration;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.weblayer.listener.TinyServletContext;
import org.tinygroup.xmlparser.node.XmlNode;

public class TinyListenerProcessor
extends AbstractConfiguration
implements ApplicationProcessor {
    private static final String CONTEXT_PARAM = "context-param";
    private static final String LISTENER_BEAN = "listener-bean";
    private static final String LISTENER_NODE_PATH = "/application/tiny-listener";
    public static final String LISTENER_NODE_CONFIG = "tiny-listener-config";
    private List<ServletContextListener> listeners = CollectionUtil.createArrayList();
    private ServletContextEvent event;

    public void start() {
        this.initListeners();
        this.startListeners();
    }

    private void startListeners() {
        for (ServletContextListener listener : this.listeners) {
            listener.contextInitialized(this.event);
        }
    }

    private void initListeners() {
        List listenerNodes = ConfigurationUtil.combineSubList((String)LISTENER_BEAN, (XmlNode)this.applicationConfig, (XmlNode)this.componentConfig);
        for (XmlNode node : listenerNodes) {
            ServletContextListener listener = (ServletContextListener)SpringUtil.getBean((String)node.getAttribute("name"));
            this.listeners.add(listener);
        }
        TinyServletContext servletContext = (TinyServletContext)ServletContextHolder.getServletContext();
        if (servletContext != null) {
            servletContext.setFullContextFileRepository((FullContextFileRepository)SpringUtil.getBean(FullContextFileRepository.class));
            this.event = new ServletContextEvent((ServletContext)servletContext);
            List paramNodes = ConfigurationUtil.combineSubList((String)CONTEXT_PARAM, (XmlNode)this.applicationConfig, (XmlNode)this.componentConfig);
            for (XmlNode node : paramNodes) {
                String name = node.getAttribute("name");
                String value = node.getAttribute("value");
                servletContext.setInitParameter(name, value);
            }
            servletContext.setInitParameter(LISTENER_NODE_CONFIG, this.applicationConfig.toString());
        }
    }

    public void stop() {
        this.stopListeners();
    }

    private void stopListeners() {
        for (ServletContextListener listener : this.listeners) {
            listener.contextDestroyed(this.event);
        }
    }

    public String getApplicationNodePath() {
        return LISTENER_NODE_PATH;
    }

    public String getComponentConfigPath() {
        return "/tinylistener.config.xml";
    }

    public void setApplication(Application application) {
    }
}

