/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;

public class FullContextUrlRedirectTinyProcessor
extends AbstractTinyProcessor {
    private static final String CACHE_CONTROL = "max-age=315360000";
    private FullContextFileRepository fullContextFileRepository;
    private static final Logger logger = LoggerFactory.getLogger(FullContextUrlRedirectTinyProcessor.class);

    public void init() {
        super.init();
        this.fullContextFileRepository = (FullContextFileRepository)SpringUtil.getBean((String)"fullContextFileRepository");
    }

    public void reallyProcess(String servletPath, WebContext context) {
        logger.logMessage(LogLevel.DEBUG, "{}\u5f00\u59cb\u5904\u7406...", new Object[]{servletPath});
        HttpServletResponse response = context.getResponse();
        HttpServletRequest request = context.getRequest();
        FileObject fileObject = this.fullContextFileRepository.getFileObject(servletPath);
        try {
            if (fileObject != null && fileObject.isExist()) {
                String ims = request.getHeader("If-Modified-Since");
                if (ims != null && ims.length() > 0 && ims.equals(new Date(fileObject.getLastModifiedTime()).toGMTString())) {
                    response.setStatus(304);
                    return;
                }
                String dateString = new Date(fileObject.getLastModifiedTime()).toGMTString();
                response.setStatus(200);
                response.setHeader("Last-modified", dateString);
                response.setHeader("Connection", "keep-alive");
                response.setHeader("Cache-Control", CACHE_CONTROL);
                response.setHeader("Date", dateString);
                response.setContentType(this.fullContextFileRepository.getFileContentType(fileObject.getExtName()));
                ServletOutputStream outputStream = response.getOutputStream();
                BufferedInputStream stream = new BufferedInputStream(fileObject.getInputStream());
                byte[] buffer = new byte[((InputStream)stream).available()];
                ((InputStream)stream).read(buffer);
                ((InputStream)stream).close();
                ((InputStream)stream).close();
                outputStream.write(buffer);
                outputStream.close();
                logger.logMessage(LogLevel.DEBUG, "{}\u5904\u7406\u5b8c\u6210\u3002", new Object[]{servletPath});
            } else {
                response.setStatus(404);
            }
        }
        catch (IOException e) {
            logger.errorMessage("{}\u5199\u5165\u54cd\u5e94\u4fe1\u606f\u51fa\u9519", (Throwable)e, new Object[]{servletPath});
            throw new RuntimeException(e);
        }
    }
}

