/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.uiengine.config.UIComponent;
import org.tinygroup.uiengine.manager.UIComponentManager;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.tinyprocessor.FullContextUrlRedirectTinyProcessor;

public class UiEngineTinyProcessor
extends AbstractTinyProcessor {
    static Pattern urlPattern = Pattern.compile("(url[(][\"']?)(.*?)([\"']?[)])");
    UIComponentManager uiComponentManager;
    private static final String CACHE_CONTROL = "max-age=315360000";
    private FullContextFileRepository fullContextFileRepository;
    private static final Logger logger = LoggerFactory.getLogger(FullContextUrlRedirectTinyProcessor.class);

    public UIComponentManager getUiComponentManager() {
        return this.uiComponentManager;
    }

    public void setUiComponentManager(UIComponentManager uiComponentManager) {
        this.uiComponentManager = uiComponentManager;
    }

    public FullContextFileRepository getFullContextFileRepository() {
        return this.fullContextFileRepository;
    }

    public void setFullContextFileRepository(FullContextFileRepository fullContextFileRepository) {
        this.fullContextFileRepository = fullContextFileRepository;
    }

    public void init() {
        super.init();
    }

    public void reallyProcess(String servletPath, WebContext context) {
        logger.logMessage(LogLevel.DEBUG, "{}\u5f00\u59cb\u5904\u7406...", new Object[]{servletPath});
        HttpServletResponse response = context.getResponse();
        HttpServletRequest request = context.getRequest();
        boolean isDebug = true;
        String isReleaseMode = (String)context.get("TINY_IS_RELEASE_MODE");
        if (isReleaseMode != null && isReleaseMode.length() > 0) {
            isDebug = Boolean.parseBoolean(isReleaseMode);
        }
        String contextPath = (String)context.get("TINY_CONTEXT_PATH");
        try {
            String lastModifiedSign;
            if (servletPath.endsWith("uijs")) {
                lastModifiedSign = new Date(this.getJsLastModifiedSign(isDebug)).toGMTString();
                response.setContentType("text/javascript");
            } else if (servletPath.endsWith("uicss")) {
                lastModifiedSign = new Date(this.getCssLastModifiedSign(isDebug)).toGMTString();
                response.setContentType("text/css");
            } else {
                throw new RuntimeException("UiEngineTinyProcessor\u4e0d\u80fd\u5904\u7406\u8bf7\u6c42\uff1a" + servletPath);
            }
            String ims = request.getHeader("If-Modified-Since");
            if (ims != null && ims.length() > 0 && ims.equals(lastModifiedSign)) {
                response.setStatus(304);
                return;
            }
            response.setStatus(200);
            response.setHeader("Last-modified", lastModifiedSign);
            response.setHeader("Connection", "keep-alive");
            response.setHeader("Cache-Control", CACHE_CONTROL);
            response.setHeader("Date", lastModifiedSign);
            if (servletPath.endsWith("uijs")) {
                this.writeJs(response, isDebug);
            }
            if (servletPath.endsWith("uicss")) {
                this.writeCss(contextPath, response, servletPath, isDebug);
            }
            logger.logMessage(LogLevel.DEBUG, "{}\u5904\u7406\u5b8c\u6210\u3002", new Object[]{servletPath});
        }
        catch (IOException e) {
            logger.errorMessage("{}\u5199\u5165\u54cd\u5e94\u4fe1\u606f\u51fa\u9519", (Throwable)e, new Object[]{servletPath});
            throw new RuntimeException(e);
        }
    }

    private void writeJs(HttpServletResponse response, boolean isDebug) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        for (UIComponent component : this.uiComponentManager.getHealthUiComponents()) {
            String[] paths = this.uiComponentManager.getComponentJsArray(component, isDebug);
            if (paths != null) {
                for (String path : paths) {
                    logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u5904\u7406js\u6587\u4ef6:<{}>", new Object[]{path});
                    FileObject fileObject = this.fullContextFileRepository.getFileObject(path);
                    BufferedInputStream stream = new BufferedInputStream(fileObject.getInputStream());
                    byte[] buffer = new byte[((InputStream)stream).available()];
                    ((InputStream)stream).read(buffer);
                    ((InputStream)stream).close();
                    ((InputStream)stream).close();
                    outputStream.write(buffer);
                    logger.logMessage(LogLevel.INFO, "js\u6587\u4ef6:<{}>\u5904\u7406\u5b8c\u6bd5", new Object[]{path});
                }
            }
            if (component.getJsCodelet() == null) continue;
            outputStream.write(component.getJsCodelet().getBytes("UTF-8"));
        }
        outputStream.close();
    }

    private void writeCss(String contextPath, HttpServletResponse response, String servletPath, boolean isDebug) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write("@charset \"utf-8\";\n".getBytes());
        for (UIComponent component : this.uiComponentManager.getHealthUiComponents()) {
            String[] paths = this.uiComponentManager.getComponentCssArray(component, isDebug);
            if (paths != null) {
                for (String path : paths) {
                    logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u5904\u7406css\u6587\u4ef6:<{}>", new Object[]{path});
                    FileObject fileObject = this.fullContextFileRepository.getFileObject(path);
                    BufferedInputStream stream = new BufferedInputStream(fileObject.getInputStream());
                    byte[] buffer = new byte[((InputStream)stream).available()];
                    ((InputStream)stream).read(buffer);
                    ((InputStream)stream).close();
                    this.writeCss((OutputStream)outputStream, contextPath, new String(buffer, "UTF-8"), fileObject.getPath());
                    outputStream.write(10);
                    logger.logMessage(LogLevel.INFO, "css\u6587\u4ef6:<{}>\u5904\u7406\u5b8c\u6bd5", new Object[]{path});
                }
            }
            if (component.getCssCodelet() == null) continue;
            this.writeCss((OutputStream)outputStream, contextPath, component.getCssCodelet(), servletPath);
        }
        outputStream.close();
    }

    private void writeCss(OutputStream outputStream, String contextPath, String string, String servletPath) throws IOException {
        Matcher matcher = urlPattern.matcher(string);
        int curpos = 0;
        while (matcher.find()) {
            outputStream.write(string.substring(curpos, matcher.start()).getBytes("UTF-8"));
            outputStream.write(matcher.group(1).getBytes("UTF-8"));
            outputStream.write(UiEngineTinyProcessor.convertUrl(contextPath, matcher.group(2), servletPath).getBytes("UTF-8"));
            outputStream.write(matcher.group(3).getBytes("UTF-8"));
            curpos = matcher.end();
        }
        outputStream.write(string.substring(curpos).getBytes("UTF-8"));
    }

    private static String convertUrl(String contextPath, String url, String servletPath) {
        if (contextPath == null) {
            contextPath = "";
        }
        if (url.startsWith("/") || url.startsWith("\\")) {
            return contextPath + url;
        }
        if (url.startsWith("../") || url.startsWith("..\\")) {
            String firstThree = url.substring(0, 3);
            int count = 0;
            while (url.startsWith(firstThree)) {
                ++count;
                url = url.substring(3);
            }
            String[] paths = servletPath.split("/");
            StringBuffer sb = new StringBuffer(contextPath);
            for (int i = 0; i < paths.length - count - 1; ++i) {
                sb.append(paths[i]).append("/");
            }
            sb.append(url);
            return sb.toString();
        }
        return contextPath + servletPath.substring(0, servletPath.lastIndexOf(47) + 1) + url;
    }

    private synchronized long getJsLastModifiedSign(boolean isDebug) {
        long time = 0L;
        for (UIComponent component : this.uiComponentManager.getHealthUiComponents()) {
            String[] paths = this.uiComponentManager.getComponentJsArray(component, isDebug);
            if (paths == null) continue;
            for (String path : paths) {
                FileObject fileObject = this.fullContextFileRepository.getFileObject(path);
                if (fileObject.isExist()) {
                    time += fileObject.getLastModifiedTime();
                    time += (long)path.hashCode();
                    continue;
                }
                throw new RuntimeException("\u4e0d\u80fd\u627e\u5230\u8d44\u6e90\u6587\u4ef6\uff1a" + path);
            }
        }
        return time;
    }

    private long getCssLastModifiedSign(boolean isDebug) {
        long time = 0L;
        for (UIComponent component : this.uiComponentManager.getHealthUiComponents()) {
            String[] paths = this.uiComponentManager.getComponentCssArray(component, isDebug);
            if (paths == null) continue;
            for (String path : paths) {
                FileObject fileObject = this.fullContextFileRepository.getFileObject(path);
                if (fileObject.isExist()) {
                    time += fileObject.getLastModifiedTime();
                    time += (long)path.hashCode();
                    continue;
                }
                throw new RuntimeException("\u4e0d\u80fd\u627e\u5230\u8d44\u6e90\u6587\u4ef6\uff1a" + path);
            }
        }
        return time;
    }
}

