/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.cache;

import java.util.regex.Pattern;
import org.tinygroup.weblayer.WebContext;

public class CacheMapping {
    private String patternStr;
    private String paramNames;
    private Long timeToLived;
    private Pattern pattern;
    private String[] names;

    public CacheMapping(String patternStr, String paramNames, Long timeToLived) {
        this.patternStr = patternStr;
        this.paramNames = paramNames;
        this.timeToLived = timeToLived;
        this.pattern = Pattern.compile(patternStr);
        if (paramNames != null) {
            this.names = paramNames.split(",");
        }
    }

    public String getCacheKey(String accessPath, WebContext webContext) {
        StringBuffer cacheKey = new StringBuffer(accessPath);
        if (this.names != null && this.names.length > 0) {
            cacheKey.append("?");
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                String value = webContext.getRequest().getParameter(name);
                String paramValue = "";
                if (value != null) {
                    paramValue = String.valueOf(value);
                }
                cacheKey.append(name).append("=").append(paramValue);
                if (i == this.names.length - 1) continue;
                cacheKey.append("&");
            }
        }
        return cacheKey.toString();
    }

    public boolean matches(String accessPath) {
        return this.pattern.matcher(accessPath).matches();
    }

    public String getPatternStr() {
        return this.patternStr;
    }

    public void setPatternStr(String patternStr) {
        this.patternStr = patternStr;
    }

    public String getParamNames() {
        return this.paramNames;
    }

    public void setParamNames(String paramNames) {
        this.paramNames = paramNames;
    }

    public Long getTimeToLived() {
        return this.timeToLived;
    }

    public void setTimeToLived(Long timeToLived) {
        this.timeToLived = timeToLived;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }
}

