/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.cache;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.cache.Cache;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.cache.CacheMapping;
import org.tinygroup.weblayer.webcontext.cache.PageCacheObject;

public class CacheOperater {
    public static final String DEFAULT_CACHE_GROUP_NAME = "pageCached";
    private Cache cache;
    private List<CacheMapping> cacheMappings = new ArrayList<CacheMapping>();

    public CacheOperater(Cache cache) {
        this.cache = cache;
    }

    public void addMapping(String patternStr, String paramNames, Long timeToLived) {
        CacheMapping cacheMapping = new CacheMapping(patternStr, paramNames, timeToLived);
        this.cacheMappings.add(cacheMapping);
    }

    public void putCache(String accessPath, String output, WebContext webcontext) {
        CacheMapping cacheMapping = this.getCacheMapping(accessPath);
        if (cacheMapping != null) {
            String cacheKey = this.getCacheKey(accessPath, webcontext);
            Long timeAlive = cacheMapping.getTimeToLived();
            this.cache.put(DEFAULT_CACHE_GROUP_NAME, cacheKey, (Object)new PageCacheObject(output, System.currentTimeMillis() + timeAlive * 1000L));
        }
    }

    private String getCacheKey(String accessPath, WebContext webcontext) {
        String cacheKey = accessPath;
        CacheMapping cacheMapping = this.getCacheMapping(accessPath);
        if (cacheMapping != null) {
            cacheKey = cacheMapping.getCacheKey(accessPath, webcontext);
        }
        return cacheKey;
    }

    public boolean isInValid(String cacheKey) {
        Long time;
        PageCacheObject cacheObject = this.getPageCacheObject(cacheKey);
        return cacheObject != null && (time = cacheObject.getTimeToLived()) != null && time < System.currentTimeMillis();
    }

    private PageCacheObject getPageCacheObject(String cacheKey) {
        try {
            return (PageCacheObject)this.cache.get(DEFAULT_CACHE_GROUP_NAME, cacheKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCacheContent(String accessPath, WebContext webcontext) {
        if (!this.isCachePath(accessPath)) {
            return null;
        }
        String cacheKey = this.getCacheKey(accessPath, webcontext);
        if (this.isInValid(cacheKey)) {
            this.cache.remove(DEFAULT_CACHE_GROUP_NAME, cacheKey);
            return null;
        }
        PageCacheObject cacheObject = this.getPageCacheObject(cacheKey);
        if (cacheObject != null) {
            return cacheObject.getContent();
        }
        return null;
    }

    public boolean isCachePath(String accessPath) {
        return this.getCacheMapping(accessPath) != null;
    }

    private CacheMapping getCacheMapping(String accessPath) {
        for (CacheMapping cacheMapping : this.cacheMappings) {
            if (!cacheMapping.matches(accessPath)) continue;
            return cacheMapping;
        }
        return null;
    }
}

