/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.cache.impl;

import java.io.IOException;
import java.io.PrintWriter;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.AbstractWebContextWrapper;
import org.tinygroup.weblayer.webcontext.buffered.BufferedWebContext;
import org.tinygroup.weblayer.webcontext.cache.CacheOperater;
import org.tinygroup.weblayer.webcontext.cache.PageCacheWebContext;
import org.tinygroup.weblayer.webcontext.cache.exception.PageCacheOutputException;
import org.tinygroup.weblayer.webcontext.util.WebContextUtil;

public class PageCacheWebContextImpl
extends AbstractWebContextWrapper
implements PageCacheWebContext {
    private CacheOperater operater;

    public PageCacheWebContextImpl(WebContext wrappedContext) {
        super(wrappedContext);
    }

    public boolean isCached(String accessPath) {
        String content = this.operater.getCacheContent(accessPath, this);
        return content != null;
    }

    public void cacheOutputPage(String accessPath) {
        String content = this.operater.getCacheContent(accessPath, this);
        if (content != null) {
            try {
                PrintWriter writer = this.getResponse().getWriter();
                writer.write(content);
            }
            catch (IOException e) {
                throw new PageCacheOutputException(e);
            }
        }
    }

    public void setCacheOperater(CacheOperater operater) {
        this.operater = operater;
    }

    public void putCachePage(String accessPath) {
        if (this.isCachePath(accessPath)) {
            BufferedWebContext buffer = WebContextUtil.findWebContext(this, BufferedWebContext.class);
            String content = buffer.peekCharBuffer();
            this.operater.putCache(accessPath, content, this);
        }
    }

    public boolean isCachePath(String accessPath) {
        return this.operater.isCachePath(accessPath);
    }
}

