/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.upload;

import java.io.File;
import java.util.Arrays;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.HumanReadableSize;
import org.tinygroup.commons.tools.SystemUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadConfiguration;

public class UploadParameters
implements UploadConfiguration {
    private File repository;
    private HumanReadableSize sizeMax = new HumanReadableSize(-1L);
    private HumanReadableSize fileSizeMax = new HumanReadableSize(-1L);
    private HumanReadableSize sizeThreshold = new HumanReadableSize(10240L);
    private boolean keepFormFieldInMemory;
    private boolean saveInFile;
    private String[] fileNameKey;
    private boolean diskItemFactory = true;
    private String itemStorageBeanName;

    public boolean isDiskItemFactory() {
        return this.diskItemFactory;
    }

    public void setDiskItemFactory(boolean diskItemFactory) {
        this.diskItemFactory = diskItemFactory;
    }

    public String getItemStorageBeanName() {
        return this.itemStorageBeanName;
    }

    public void setItemStorageBeanName(String itemStorageBeanName) {
        this.itemStorageBeanName = itemStorageBeanName;
    }

    public File getRepository() {
        return this.repository;
    }

    public void setRepository(File repository) {
        this.repository = repository;
    }

    public HumanReadableSize getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(HumanReadableSize sizeMax) {
        this.sizeMax = (HumanReadableSize)Assert.assertNotNull((Object)sizeMax, (String)"sizeMax", (Object[])new Object[0]);
    }

    public void setSizeMax(long sizeMax) {
        this.setSizeMax(new HumanReadableSize(sizeMax));
    }

    public HumanReadableSize getFileSizeMax() {
        return this.fileSizeMax;
    }

    public void setFileSizeMax(HumanReadableSize fileSizeMax) {
        this.fileSizeMax = (HumanReadableSize)Assert.assertNotNull((Object)fileSizeMax, (String)"fileSizeMax", (Object[])new Object[0]);
    }

    public void setFileSizeMax(long fileSizeMax) {
        this.setFileSizeMax(new HumanReadableSize(fileSizeMax));
    }

    public HumanReadableSize getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setSizeThreshold(HumanReadableSize sizeThreshold) {
        this.sizeThreshold = (HumanReadableSize)Assert.assertNotNull((Object)sizeThreshold, (String)"sizeThreshold", (Object[])new Object[0]);
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = new HumanReadableSize((long)sizeThreshold);
    }

    public boolean isKeepFormFieldInMemory() {
        return this.keepFormFieldInMemory;
    }

    public void setKeepFormFieldInMemory(boolean keepFormFieldInMemory) {
        this.keepFormFieldInMemory = keepFormFieldInMemory;
    }

    public boolean isSaveInFile() {
        return this.saveInFile;
    }

    public void setSaveInFile(boolean saveInFile) {
        this.saveInFile = saveInFile;
    }

    public String[] getFileNameKey() {
        return this.fileNameKey;
    }

    public void setFileNameKey(String[] fileNameKey) {
        this.fileNameKey = fileNameKey;
    }

    public void applyDefaultValues() {
        if (this.sizeThreshold.getValue() == 0L) {
            this.keepFormFieldInMemory = true;
        }
        if (this.repository == null) {
            this.repository = new File(SystemUtil.getUserInfo().getTempDir());
        }
        if (!this.repository.exists() && !this.repository.mkdirs()) {
            throw new IllegalArgumentException("Could not create repository directory for file uploading: " + this.repository);
        }
        if (ArrayUtil.isEmptyArray((Object)this.fileNameKey)) {
            this.fileNameKey = new String[]{"filename"};
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof UploadParameters)) {
            return false;
        }
        UploadParameters other = (UploadParameters)obj;
        if (this.repository == null ? other.repository != null : !this.repository.equals(other.repository)) {
            return false;
        }
        if (this.sizeMax != other.sizeMax) {
            return false;
        }
        if (this.fileSizeMax != other.fileSizeMax) {
            return false;
        }
        if (this.sizeThreshold != other.sizeThreshold) {
            return false;
        }
        if (this.keepFormFieldInMemory != other.keepFormFieldInMemory) {
            return false;
        }
        return Arrays.equals(this.fileNameKey, other.fileNameKey);
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("Repository Path", (Object)this.getRepository());
        mb.append("Maximum Request Size", (Object)this.getSizeMax());
        mb.append("Maximum File Size", (Object)this.getFileSizeMax());
        mb.append("Threshold before Writing to File", (Object)this.getSizeThreshold());
        mb.append("Keep Form Field in Memory", (Object)this.isKeepFormFieldInMemory());
        mb.append("File Name Key", (Object)this.getFileNameKey());
        return mb.toString();
    }
}

